/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inputs;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.plugin.AbstractDescriptor;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Stoppable;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.buffers.InputBuffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.inputs.MisfireException;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.journal.RawMessage;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageInput
implements Stoppable {
    private static final Logger LOG = LoggerFactory.getLogger(MessageInput.class);
    public static final String FIELD_ID = "_id";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_NODE_ID = "node_id";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_CONFIGURATION = "configuration";
    public static final String FIELD_CREATOR_USER_ID = "creator_user_id";
    public static final String FIELD_CREATED_AT = "created_at";
    public static final String FIELD_STARTED_AT = "started_at";
    public static final String FIELD_ATTRIBUTES = "attributes";
    public static final String FIELD_STATIC_FIELDS = "static_fields";
    public static final String FIELD_GLOBAL = "global";
    public static final String FIELD_CONTENT_PACK = "content_pack";
    private static long defaultRecvBufferSize = 0x100000L;
    private final MetricRegistry metricRegistry;
    private final Transport transport;
    private final MetricRegistry localRegistry;
    private final Codec codec;
    private final Descriptor descriptor;
    private final ServerStatus serverStatus;
    private final Meter incomingMessages;
    private final Meter rawSize;
    private final Map<String, String> staticFields = Maps.newConcurrentMap();
    private final ConfigurationRequest requestedConfiguration;
    private final Configuration codecConfig;
    private final Counter globalIncomingMessages;
    private final Counter emptyMessages;
    protected String title;
    protected String creatorUserId;
    protected String persistId;
    protected DateTime createdAt;
    protected Boolean global = false;
    protected String contentPack;
    protected final Configuration configuration;
    protected InputBuffer inputBuffer;
    private String nodeId;
    private MetricSet transportMetrics;

    public MessageInput(MetricRegistry metricRegistry, Configuration configuration, Transport transport, LocalMetricRegistry localRegistry, Codec codec, Config config, Descriptor descriptor, ServerStatus serverStatus) {
        this.configuration = configuration;
        if (metricRegistry == localRegistry) {
            LOG.error("########### Do not add the global metric registry twice, the localRegistry parameter is the same as the global metricRegistry. This will cause duplicated metrics and is a bug. Use LocalMetricRegistry in your input instead.");
        }
        this.metricRegistry = metricRegistry;
        this.transport = transport;
        this.localRegistry = localRegistry;
        this.codec = codec;
        this.descriptor = descriptor;
        this.serverStatus = serverStatus;
        this.requestedConfiguration = config.combinedRequestedConfiguration();
        this.codecConfig = config.codecConfig.getRequestedConfiguration().filter(codec.getConfiguration());
        this.rawSize = localRegistry.meter("rawSize");
        this.incomingMessages = localRegistry.meter("incomingMessages");
        this.globalIncomingMessages = metricRegistry.counter("org.graylog2.throughput.input");
        this.emptyMessages = localRegistry.counter("emptyMessages");
    }

    public static long getDefaultRecvBufferSize() {
        return defaultRecvBufferSize;
    }

    public static void setDefaultRecvBufferSize(long size) {
        defaultRecvBufferSize = size;
    }

    public void initialize() {
        this.transportMetrics = this.transport.getMetricSet();
        try {
            if (this.transportMetrics != null) {
                this.metricRegistry.register(this.getUniqueReadableId(), (Metric)this.transportMetrics);
            }
            this.metricRegistry.register(this.getUniqueReadableId(), (Metric)this.localRegistry);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void checkConfiguration() throws ConfigurationException {
        ConfigurationRequest cr = this.getRequestedConfiguration();
        cr.check(this.getConfiguration());
    }

    public void launch(InputBuffer buffer) throws MisfireException {
        this.inputBuffer = buffer;
        try {
            this.transport.setMessageAggregator(this.codec.getAggregator());
            this.transport.launch(this);
        }
        catch (Exception e) {
            this.inputBuffer = null;
            throw new MisfireException(e);
        }
    }

    @Override
    public void stop() {
        this.transport.stop();
        this.cleanupMetrics();
    }

    public void terminate() {
        this.cleanupMetrics();
    }

    private void cleanupMetrics() {
        if (this.localRegistry != null && this.localRegistry.getMetrics() != null) {
            for (String metricName : this.localRegistry.getMetrics().keySet()) {
                this.metricRegistry.remove(this.getUniqueReadableId() + "." + metricName);
            }
        }
        if (this.transportMetrics != null && this.transportMetrics.getMetrics() != null) {
            for (String metricName : this.transportMetrics.getMetrics().keySet()) {
                this.metricRegistry.remove(this.getUniqueReadableId() + "." + metricName);
            }
        }
    }

    public ConfigurationRequest getRequestedConfiguration() {
        return this.requestedConfiguration;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public boolean isExclusive() {
        return this.descriptor.isExclusive();
    }

    public String getId() {
        return this.persistId;
    }

    public String getPersistId() {
        return this.persistId;
    }

    public void setPersistId(String id) {
        this.persistId = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    public void setCreatorUserId(String creatorUserId) {
        this.creatorUserId = creatorUserId;
    }

    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(Boolean global) {
        this.global = global;
    }

    public String getContentPack() {
        return this.contentPack;
    }

    public void setContentPack(String contentPack) {
        this.contentPack = contentPack;
    }

    @Deprecated
    public Map<String, Object> getAttributesWithMaskedPasswords() {
        return this.configuration.getSource();
    }

    @JsonValue
    public Map<String, Object> asMapMasked() {
        Map<String, Object> result = this.asMap();
        result.remove(FIELD_CONFIGURATION);
        result.put(FIELD_ATTRIBUTES, this.getAttributesWithMaskedPasswords());
        return result;
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FIELD_TYPE, this.getClass().getCanonicalName());
        map.put(FIELD_NAME, this.getName());
        map.put(FIELD_TITLE, this.getTitle());
        map.put(FIELD_CREATOR_USER_ID, this.getCreatorUserId());
        map.put(FIELD_GLOBAL, this.isGlobal());
        map.put(FIELD_CONTENT_PACK, this.getContentPack());
        map.put(FIELD_CONFIGURATION, this.getConfiguration().getSource());
        if (this.getCreatedAt() != null) {
            map.put(FIELD_CREATED_AT, this.getCreatedAt());
        } else {
            map.put(FIELD_CREATED_AT, Tools.nowUTC());
        }
        if (this.getStaticFields() != null && !this.getStaticFields().isEmpty()) {
            map.put(FIELD_STATIC_FIELDS, this.getStaticFields());
        }
        if (!this.isGlobal().booleanValue()) {
            map.put(FIELD_NODE_ID, this.getNodeId());
        }
        return map;
    }

    public void addStaticField(String key, String value) {
        this.staticFields.put(key, value);
    }

    public void addStaticFields(Map<String, String> staticFields) {
        this.staticFields.putAll(staticFields);
    }

    public Map<String, String> getStaticFields() {
        return this.staticFields;
    }

    public String getUniqueReadableId() {
        return this.getClass().getName() + "." + this.getId();
    }

    public int hashCode() {
        return this.getPersistId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageInput) {
            MessageInput input = (MessageInput)obj;
            return this.getPersistId().equals(input.getPersistId());
        }
        return false;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public void processRawMessage(RawMessage rawMessage) {
        if (rawMessage.getPayload().length == 0) {
            LOG.debug("Discarding empty message {} from input [{}/{}] (remote address {}). Turn logger org.graylog2.plugin.journal.RawMessage to TRACE to see originating stack trace.", new Object[]{rawMessage.getId(), this.getTitle(), this.getId(), rawMessage.getRemoteAddress() == null ? "unknown" : rawMessage.getRemoteAddress()});
            this.emptyMessages.inc();
            return;
        }
        rawMessage.setCodecName(this.codec.getName());
        rawMessage.setCodecConfig(this.codecConfig);
        rawMessage.addSourceNode(this.getId(), this.serverStatus.getNodeId());
        this.inputBuffer.insert(rawMessage);
        this.incomingMessages.mark();
        this.globalIncomingMessages.inc();
        this.rawSize.mark((long)rawMessage.getPayload().length);
    }

    public String getType() {
        return this.getClass().getCanonicalName();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(FIELD_TITLE, (Object)this.getTitle()).add(FIELD_TYPE, (Object)this.getType()).add("nodeId", (Object)this.getNodeId()).toString();
    }

    public static class Descriptor
    extends AbstractDescriptor {
        public Descriptor() {
        }

        protected Descriptor(String name, boolean exclusive, String linkToDocs) {
            super(name, exclusive, linkToDocs);
        }
    }

    public static class Config {
        public final Transport.Config transportConfig;
        public final Codec.Config codecConfig;

        Config() {
            throw new IllegalStateException("This class should not be instantiated directly, this is a bug.");
        }

        protected Config(Transport.Config transportConfig, Codec.Config codecConfig) {
            this.transportConfig = transportConfig;
            this.codecConfig = codecConfig;
        }

        public ConfigurationRequest combinedRequestedConfiguration() {
            ConfigurationRequest transport = this.transportConfig.getRequestedConfiguration();
            ConfigurationRequest codec = this.codecConfig.getRequestedConfiguration();
            ConfigurationRequest r = new ConfigurationRequest();
            r.putAll(transport.getFields());
            r.putAll(codec.getFields());
            this.codecConfig.overrideDefaultValues(r);
            return r;
        }
    }

    public static interface Factory<M> {
        public M create(Configuration var1);

        public Config getConfig();

        public Descriptor getDescriptor();
    }
}

