/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import java.util.List;
import javax.inject.Inject;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.alarmcallbacks.AlarmCallbackFactory;
import org.graylog2.alarmcallbacks.AlarmCallbackHistory;
import org.graylog2.alarmcallbacks.AlarmCallbackHistoryService;
import org.graylog2.alerts.Alert;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.streams.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertNotificationsSender {
    private static final Logger LOG = LoggerFactory.getLogger(AlertNotificationsSender.class);
    private final AlarmCallbackConfigurationService alarmCallbackConfigurationService;
    private final AlarmCallbackFactory alarmCallbackFactory;
    private final AlarmCallbackHistoryService alarmCallbackHistoryService;

    @Inject
    public AlertNotificationsSender(AlarmCallbackConfigurationService alarmCallbackConfigurationService, AlarmCallbackFactory alarmCallbackFactory, AlarmCallbackHistoryService alarmCallbackHistoryService) {
        this.alarmCallbackConfigurationService = alarmCallbackConfigurationService;
        this.alarmCallbackFactory = alarmCallbackFactory;
        this.alarmCallbackHistoryService = alarmCallbackHistoryService;
    }

    public void send(AlertCondition.CheckResult result, Stream stream, Alert alert, AlertCondition alertCondition) {
        List<AlarmCallbackConfiguration> callConfigurations = this.alarmCallbackConfigurationService.getForStream(stream);
        for (AlarmCallbackConfiguration configuration : callConfigurations) {
            AlarmCallbackHistory alarmCallbackHistory;
            AlarmCallback alarmCallback = null;
            try {
                alarmCallback = this.alarmCallbackFactory.create(configuration);
                alarmCallback.call(stream, result);
                alarmCallbackHistory = this.alarmCallbackHistoryService.success(configuration, alert, alertCondition);
            }
            catch (Exception e) {
                if (alarmCallback != null) {
                    LOG.warn("Alarm callback <" + alarmCallback.getName() + "> failed. Skipping.", (Throwable)e);
                } else {
                    LOG.warn("Alarm callback with id " + configuration.getId() + " failed. Skipping.", (Throwable)e);
                }
                alarmCallbackHistory = this.alarmCallbackHistoryService.error(configuration, alert, alertCondition, e.getMessage());
            }
            try {
                this.alarmCallbackHistoryService.save(alarmCallbackHistory);
            }
            catch (Exception e) {
                LOG.warn("Unable to save history of alarm callback run: ", (Throwable)e);
            }
        }
    }
}

