/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.messages;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.github.joschi.jadconfig.util.Duration;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.collect.ImmutableMap;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import io.searchbox.core.DocumentResult;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import io.searchbox.indices.Analyze;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.indexer.IndexFailure;
import org.graylog2.indexer.IndexFailureImpl;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.messages.DocumentNotFoundException;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.plugin.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Messages {
    private static final Logger LOG = LoggerFactory.getLogger(Messages.class);
    private static final Duration MAX_WAIT_TIME = Duration.seconds((long)30L);
    private static final Retryer<BulkResult> BULK_REQUEST_RETRYER = RetryerBuilder.newBuilder().retryIfException(t -> t instanceof IOException).withWaitStrategy(WaitStrategies.exponentialWait((long)MAX_WAIT_TIME.getQuantity(), (TimeUnit)MAX_WAIT_TIME.getUnit())).withRetryListener(new RetryListener(){

        public <V> void onRetry(Attempt<V> attempt) {
            if (attempt.hasException()) {
                LOG.error("Caught exception during bulk indexing: {}, retrying (attempt #{}).", (Object)attempt.getExceptionCause(), (Object)attempt.getAttemptNumber());
            } else if (attempt.getAttemptNumber() > 1L) {
                LOG.info("Bulk indexing finally successful (attempt #{}).", (Object)attempt.getAttemptNumber());
            }
        }
    }).build();
    private final Meter invalidTimestampMeter;
    private final JestClient client;
    private final LinkedBlockingQueue<List<IndexFailure>> indexFailureQueue;
    private final Counter outputByteCounter;
    private final Counter systemTrafficCounter;

    @Inject
    public Messages(MetricRegistry metricRegistry, JestClient client) {
        this.invalidTimestampMeter = metricRegistry.meter(MetricRegistry.name(Messages.class, (String[])new String[]{"invalid-timestamps"}));
        this.outputByteCounter = metricRegistry.counter("org.graylog2.traffic.output");
        this.systemTrafficCounter = metricRegistry.counter("org.graylog2.traffic.system-output-traffic");
        this.client = client;
        this.indexFailureQueue = new LinkedBlockingQueue(1000);
    }

    public ResultMessage get(String messageId, String index) throws DocumentNotFoundException, IOException {
        Get get = ((Get.Builder)new Get.Builder(index, messageId).type("message")).build();
        DocumentResult result = (DocumentResult)this.client.execute((Action)get);
        if (!result.isSucceeded()) {
            throw new DocumentNotFoundException(index, messageId);
        }
        Map message = (Map)result.getSourceAsObject(Map.class, false);
        return ResultMessage.parseFromSource(result.getId(), result.getIndex(), message);
    }

    public List<String> analyze(String toAnalyze, String index, String analyzer) throws IOException {
        Analyze analyze = new Analyze.Builder().index(index).analyzer(analyzer).text(toAnalyze).build();
        JestResult result = this.client.execute((Action)analyze);
        List tokens = (List)result.getValue("tokens");
        ArrayList<String> terms = new ArrayList<String>(tokens.size());
        tokens.forEach(token -> terms.add((String)token.get("token")));
        return terms;
    }

    public List<String> bulkIndex(List<Map.Entry<IndexSet, Message>> messageList) {
        return this.bulkIndex(messageList, false);
    }

    public List<String> bulkIndex(List<Map.Entry<IndexSet, Message>> messageList, boolean isSystemTraffic) {
        if (messageList.isEmpty()) {
            return Collections.emptyList();
        }
        Bulk.Builder bulk = new Bulk.Builder();
        for (Map.Entry<IndexSet, Message> entry : messageList) {
            Message message = entry.getValue();
            if (isSystemTraffic) {
                this.systemTrafficCounter.inc(message.getSize());
            } else {
                this.outputByteCounter.inc(message.getSize());
            }
            bulk.addAction((BulkableAction)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder(message.toElasticSearchObject(this.invalidTimestampMeter)).index(entry.getKey().getWriteIndexAlias())).type("message")).id(message.getId())).build());
        }
        BulkResult result = this.runBulkRequest(bulk.build(), messageList.size());
        List failedItems = result.getFailedItems();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Index: Bulk indexed {} messages, took {} ms, failures: {}", new Object[]{result.getItems().size(), result, failedItems.size()});
        }
        if (!failedItems.isEmpty()) {
            return this.propagateFailure(failedItems, messageList, result.getErrorMessage());
        }
        return Collections.emptyList();
    }

    private BulkResult runBulkRequest(Bulk request, int count) {
        try {
            return (BulkResult)BULK_REQUEST_RETRYER.call(() -> (BulkResult)this.client.execute((Action)request));
        }
        catch (RetryException | ExecutionException e) {
            if (e instanceof RetryException) {
                LOG.error("Could not bulk index {} messages. Giving up after {} attempts.", (Object)count, (Object)((RetryException)e).getNumberOfFailedAttempts());
            } else {
                LOG.error("Couldn't bulk index " + count + " messages.", e);
            }
            throw new RuntimeException(e);
        }
    }

    private List<String> propagateFailure(List<BulkResult.BulkResultItem> items, List<Map.Entry<IndexSet, Message>> messageList, String errorMessage) {
        Map messageMap = messageList.stream().map(Map.Entry::getValue).distinct().collect(Collectors.toMap(Message::getId, Function.identity()));
        ArrayList<String> failedMessageIds = new ArrayList<String>(items.size());
        ArrayList<IndexFailureImpl> indexFailures = new ArrayList<IndexFailureImpl>(items.size());
        for (BulkResult.BulkResultItem item : items) {
            LOG.warn("Failed to index message: index=<{}> id=<{}> error=<{}>", new Object[]{item.index, item.id, item.error});
            Message messageEntry = (Message)messageMap.get(item.id);
            ImmutableMap doc = ImmutableMap.builder().put((Object)"letter_id", (Object)item.id).put((Object)"index", (Object)item.index).put((Object)"type", (Object)item.type).put((Object)"message", (Object)item.error).put((Object)"timestamp", (Object)messageEntry.getTimestamp()).build();
            indexFailures.add(new IndexFailureImpl((Map<String, Object>)doc));
            failedMessageIds.add(item.id);
        }
        LOG.error("Failed to index [{}] messages. Please check the index error log in your web interface for the reason. Error: {}", (Object)indexFailures.size(), (Object)errorMessage);
        try {
            this.indexFailureQueue.offer(indexFailures, 25L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Couldn't save index failures.", (Throwable)e);
        }
        return failedMessageIds;
    }

    public Index prepareIndexRequest(String index, Map<String, Object> source, String id) {
        source.remove("_id");
        return ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder(source).index(index)).type("message")).id(id)).setParameter("consistency", (Object)"one")).build();
    }

    public LinkedBlockingQueue<List<IndexFailure>> getIndexFailureQueue() {
        return this.indexFailureQueue;
    }
}

