/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import com.google.common.collect.Sets;
import java.util.List;
import javax.inject.Inject;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.MongoDbAuthorizationCacheManager;
import org.graylog2.security.realm.UserAuthorizationInfo;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbAuthorizationRealm
extends AuthorizingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbAuthorizationRealm.class);
    private final UserService userService;

    @Inject
    MongoDbAuthorizationRealm(UserService userService, MongoDbAuthorizationCacheManager mongoDbAuthorizationCacheManager) {
        this.userService = userService;
        this.setCachingEnabled(true);
        this.setCacheManager(mongoDbAuthorizationCacheManager);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        LOG.debug("Retrieving authorization information for {}", (Object)principals);
        User user = this.userService.load(principals.getPrimaryPrincipal().toString());
        if (user == null) {
            return new SimpleAuthorizationInfo();
        }
        UserAuthorizationInfo info = new UserAuthorizationInfo(user);
        List<String> permissions = user.getPermissions();
        if (permissions != null) {
            info.setStringPermissions(Sets.newHashSet(permissions));
        }
        info.setRoles(user.getRoleIds());
        LOG.debug("User {} has permissions: {}", (Object)principals, permissions);
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        return null;
    }
}

