/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats.jvm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.graylog2.shared.system.stats.jvm.AutoValue_JvmStats;
import org.graylog2.shared.system.stats.jvm.AutoValue_JvmStats_Memory;

@JsonAutoDetect
@AutoValue
public abstract class JvmStats {
    public static final JvmStats INSTANCE;

    @JsonProperty
    public abstract String version();

    @JsonProperty
    public abstract String vmName();

    @JsonProperty
    public abstract String vmVersion();

    @JsonProperty
    public abstract String vmVendor();

    @JsonProperty
    public abstract String specName();

    @JsonProperty
    public abstract String specVersion();

    @JsonProperty
    public abstract String specVendor();

    @JsonProperty
    public abstract long startTime();

    @JsonProperty
    public abstract Memory mem();

    @JsonProperty
    public abstract List<String> inputArguments();

    @JsonProperty
    public abstract String bootClassPath();

    @JsonProperty
    public abstract String classPath();

    @JsonProperty
    public abstract Map<String, String> systemProperties();

    @JsonProperty
    public abstract List<String> garbageCollectors();

    @JsonProperty
    public abstract List<String> memoryPools();

    public static JvmStats create(String version, String vmName, String vmVersion, String vmVendor, String specName, String specVersion, String specVendor, long startTime, Memory mem, List<String> inputArguments, String bootClassPath, String classPath, Map<String, String> systemProperties, List<String> garbageCollectors, List<String> memoryPools) {
        return new AutoValue_JvmStats(version, vmName, vmVersion, vmVendor, specName, specVersion, specVendor, startTime, mem, inputArguments, bootClassPath, classPath, systemProperties, garbageCollectors, memoryPools);
    }

    static {
        long directMemoryMax;
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        long heapInit = memoryMXBean.getHeapMemoryUsage().getInit();
        long heapMax = memoryMXBean.getHeapMemoryUsage().getMax();
        long nonHeapInit = memoryMXBean.getNonHeapMemoryUsage().getInit();
        long nonHeapMax = memoryMXBean.getNonHeapMemoryUsage().getMax();
        try {
            Class<?> vmClass = Class.forName("sun.misc.VM");
            directMemoryMax = (Long)vmClass.getMethod("maxDirectMemory", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            directMemoryMax = -1L;
        }
        Memory memory = Memory.create(heapInit, heapMax, nonHeapInit, nonHeapMax, directMemoryMax);
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        long startTime = runtimeMXBean.getStartTime();
        String version = runtimeMXBean.getSystemProperties().get("java.version");
        String vmName = runtimeMXBean.getVmName();
        String vmVendor = runtimeMXBean.getVmVendor();
        String vmVersion = runtimeMXBean.getVmVersion();
        String specName = runtimeMXBean.getSpecName();
        String specVendor = runtimeMXBean.getSpecVendor();
        String specVersion = runtimeMXBean.getSpecVersion();
        List<String> inputArguments = runtimeMXBean.getInputArguments();
        String bootClassPath = runtimeMXBean.getBootClassPath();
        String classPath = runtimeMXBean.getClassPath();
        Map<String, String> systemProperties = runtimeMXBean.getSystemProperties();
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        ArrayList<String> garbageCollectors = new ArrayList<String>(gcMxBeans.size());
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            garbageCollectors.add(gcMxBean.getName());
        }
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        ArrayList<String> memoryPools = new ArrayList<String>(memoryPoolMXBeans.size());
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            memoryPools.add(memoryPoolMXBean.getName());
        }
        INSTANCE = JvmStats.create(version, vmName, vmVersion, vmVendor, specName, specVersion, specVendor, startTime, memory, inputArguments, bootClassPath, classPath, systemProperties, garbageCollectors, memoryPools);
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class Memory {
        @JsonProperty
        public abstract long heapInit();

        @JsonProperty
        public abstract long heapMax();

        @JsonProperty
        public abstract long nonHeapInit();

        @JsonProperty
        public abstract long nonHeapMax();

        @JsonProperty
        public abstract long directMemoryMax();

        public static Memory create(long heapInit, long heapMax, long nonHeapInit, long nonHeapMax, long directMemoryMax) {
            return new AutoValue_JvmStats_Memory(heapInit, heapMax, nonHeapInit, nonHeapMax, directMemoryMax);
        }
    }
}

