/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets.strategies;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.strategies.QuickvaluesBaseWidgetStrategy;
import org.graylog2.indexer.results.TermsResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.dashboards.widgets.ComputationResult;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class QuickvaluesWidgetStrategy
extends QuickvaluesBaseWidgetStrategy {
    private final int dataTableLimit;

    @AssistedInject
    public QuickvaluesWidgetStrategy(Searches searches, @Assisted Map<String, Object> config, @Assisted TimeRange timeRange, @Assisted String widgetId) throws InvalidWidgetConfigurationException {
        super(searches, timeRange, config, widgetId);
        this.dataTableLimit = (Integer)MoreObjects.firstNonNull((Object)config.get("data_table_limit"), (Object)50);
    }

    @Override
    public ComputationResult compute() {
        String filter = null;
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            filter = "streams:" + this.streamId;
        }
        Sorting.Direction sortDirection = QuickvaluesWidgetStrategy.getSortingDirection(this.sortOrder);
        TermsResult terms = this.searches.terms(this.field, this.stackedFields, this.dataTableLimit, this.query, filter, this.timeRange, sortDirection);
        HashMap result = Maps.newHashMap();
        result.put("terms", terms.getTerms());
        result.put("terms_mapping", terms.termsMapping());
        result.put("total", terms.getTotal());
        result.put("other", terms.getOther());
        result.put("missing", terms.getMissing());
        return new ComputationResult(result, terms.tookMs());
    }

    public static interface Factory
    extends WidgetStrategy.Factory<QuickvaluesWidgetStrategy> {
        @Override
        public QuickvaluesWidgetStrategy create(Map<String, Object> var1, TimeRange var2, String var3);
    }
}

