/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationImpl;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.alarmcallbacks.EmailAlarmCallback;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.AutoValue_V20161125161400_AlertReceiversMigration_MigrationCompleted;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamImpl;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20161125161400_AlertReceiversMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20161125161400_AlertReceiversMigration.class);
    private final ClusterConfigService clusterConfigService;
    private final StreamService streamService;
    private final AlarmCallbackConfigurationService alarmCallbackService;
    private final DBCollection dbCollection;

    @Inject
    public V20161125161400_AlertReceiversMigration(ClusterConfigService clusterConfigService, StreamService streamService, AlarmCallbackConfigurationService alarmCallbackService, MongoConnection mongoConnection) {
        this.clusterConfigService = clusterConfigService;
        this.streamService = streamService;
        this.alarmCallbackService = alarmCallbackService;
        String collectionName = StreamImpl.class.getAnnotation(CollectionName.class).value();
        this.dbCollection = mongoConnection.getDatabase().getCollection(collectionName);
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2016-11-25T16:14:00Z");
    }

    private boolean hasAlertReceivers(Stream stream) {
        Map<String, List<String>> alertReceivers = stream.getAlertReceivers();
        if (alertReceivers == null || alertReceivers.isEmpty()) {
            return false;
        }
        List<String> users = alertReceivers.get("users");
        List<String> emails = alertReceivers.get("emails");
        return users != null && !users.isEmpty() || emails != null && !emails.isEmpty();
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            return;
        }
        Map<String, Optional<String>> streamMigrations = this.streamService.loadAll().stream().filter(stream -> this.hasAlertReceivers((Stream)stream) && !this.streamService.getAlertConditions((Stream)stream).isEmpty() && !this.alarmCallbackService.getForStream((Stream)stream).isEmpty()).collect(Collectors.toMap(Persisted::getId, this::migrateStream));
        boolean allSucceeded = streamMigrations.values().stream().allMatch(Optional::isPresent);
        long count = streamMigrations.size();
        if (allSucceeded) {
            if (count > 0L) {
                LOG.info("Successfully migrated alert receivers from " + count + " streams to its email alarm callbacks.");
            } else {
                LOG.info("No streams needed to be migrated.");
            }
            this.clusterConfigService.write(MigrationCompleted.create(streamMigrations));
        } else {
            long errors = streamMigrations.values().stream().filter(streamId -> !streamId.isPresent()).count();
            LOG.error("Failed migrating " + errors + "/" + count + " alert receivers from streams to its email alarm callbacks.");
        }
    }

    private Optional<String> migrateStream(Stream stream) {
        List<AlarmCallbackConfiguration> alarmCallbacks = this.alarmCallbackService.getForStream(stream);
        List updatedConfigurations = alarmCallbacks.stream().filter(callbackConfiguration -> callbackConfiguration.getType().equals(EmailAlarmCallback.class.getCanonicalName())).map(callbackConfiguration -> this.updateConfiguration(stream, (AlarmCallbackConfiguration)callbackConfiguration)).collect(Collectors.toList());
        if (!updatedConfigurations.stream().allMatch(Optional::isPresent)) {
            long errors = updatedConfigurations.stream().filter(streamId -> !streamId.isPresent()).count();
            LOG.error("Failed moving alert receivers in " + errors + " email alarm callbacks.");
            return Optional.empty();
        }
        this.dbCollection.update((DBObject)new BasicDBObject("_id", (Object)new ObjectId(stream.getId())), (DBObject)new BasicDBObject("$unset", (Object)new BasicDBObject("alert_receivers", (Object)"")));
        LOG.debug("Successfully removed alert receivers from stream <" + stream.getId() + ">.");
        return Optional.of(updatedConfigurations.stream().map(Optional::get).collect(Collectors.joining(", ")));
    }

    private Optional<String> updateConfiguration(Stream stream, AlarmCallbackConfiguration callbackConfiguration) {
        Map<String, List<String>> alertReceivers = stream.getAlertReceivers();
        List<String> usernames = alertReceivers.get("users");
        List<String> emails = alertReceivers.get("emails");
        Map<String, Object> configuration = callbackConfiguration.getConfiguration();
        if (usernames != null && !usernames.isEmpty()) {
            LOG.debug("Moving users alert receivers from stream <" + stream.getId() + ">");
            configuration.put("user_receivers", usernames);
        }
        if (emails != null && !emails.isEmpty()) {
            LOG.debug("Moving emails alert receivers from stream <" + stream.getId() + ">");
            configuration.put("email_receivers", emails);
        }
        AlarmCallbackConfigurationImpl updatedConfiguration = ((AlarmCallbackConfigurationImpl)callbackConfiguration).toBuilder().setConfiguration(configuration).build();
        try {
            String callbackId = this.alarmCallbackService.save(updatedConfiguration);
            LOG.debug("Successfully created email alarm callback <" + callbackId + "> for stream <" + stream.getId() + ">.");
            return Optional.of(callbackId);
        }
        catch (ValidationException e) {
            LOG.error("Unable to create email alarm callback for stream <" + stream.getId() + ">: ", (Throwable)e);
            return Optional.empty();
        }
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="stream_ids")
        public abstract Map<String, Optional<String>> streamIds();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="stream_ids") Map<String, Optional<String>> streamIds) {
            return new AutoValue_V20161125161400_AlertReceiversMigration_MigrationCompleted(streamIds);
        }
    }
}

