/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.github.joschi.jadconfig.util.Size;
import javax.inject.Inject;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.system.traffic.TrafficCounterService;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficCounterCalculator
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(TrafficCounterCalculator.class);
    private final NodeId nodeId;
    private final TrafficCounterService trafficService;
    private final MetricRegistry metricRegistry;
    private long previousInputBytes = 0L;
    private long previousOutputBytes = 0L;
    private long previousDecodedBytes = 0L;
    private Counter inputCounter;
    private Counter outputCounter;
    private Counter decodedCounter;

    @Inject
    public TrafficCounterCalculator(NodeId nodeId, TrafficCounterService trafficService, MetricRegistry metricRegistry) {
        this.nodeId = nodeId;
        this.trafficService = trafficService;
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void initialize() {
        this.inputCounter = this.metricRegistry.counter("org.graylog2.traffic.input");
        this.outputCounter = this.metricRegistry.counter("org.graylog2.traffic.output");
        this.decodedCounter = this.metricRegistry.counter("org.graylog2.traffic.decoded");
    }

    @Override
    public void doRun() {
        DateTime now = Tools.nowUTC();
        int secondOfMinute = now.getSecondOfMinute();
        if (secondOfMinute == 0) {
            LOG.trace("Calculating input and output traffic for the previous minute");
            long currentInputBytes = this.inputCounter.getCount();
            long currentOutputBytes = this.outputCounter.getCount();
            long currentDecodedBytes = this.decodedCounter.getCount();
            long inputLastMinute = currentInputBytes - this.previousInputBytes;
            this.previousInputBytes = currentInputBytes;
            long outputBytesLastMinute = currentOutputBytes - this.previousOutputBytes;
            this.previousOutputBytes = currentOutputBytes;
            long decodedBytesLastMinute = currentDecodedBytes - this.previousDecodedBytes;
            this.previousDecodedBytes = currentDecodedBytes;
            if (LOG.isDebugEnabled()) {
                Size in = Size.bytes((long)inputLastMinute);
                Size out = Size.bytes((long)outputBytesLastMinute);
                Size decoded = Size.bytes((long)decodedBytesLastMinute);
                LOG.debug("Traffic in the last minute: in: {} bytes ({} MB), out: {} bytes ({} MB}), decoded: {} bytes ({} MB})", new Object[]{in, in.toMegabytes(), out, out.toMegabytes(), decoded, decoded.toMegabytes()});
            }
            DateTime previousMinute = now.minusMinutes(1);
            this.trafficService.updateTraffic(previousMinute, this.nodeId, inputLastMinute, outputBytesLastMinute, decodedBytesLastMinute);
        }
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean masterOnly() {
        return false;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 1;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

