/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.cluster.jest;

import com.fasterxml.jackson.databind.JsonNode;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.http.JestHttpClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.http.client.config.RequestConfig;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.FieldTypeException;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.QueryParsingException;

public class JestUtils {
    private JestUtils() {
    }

    public static <T extends JestResult> T execute(JestClient client, RequestConfig requestConfig, Action<T> request, Supplier<String> errorMessage) {
        JestResult result;
        try {
            result = client instanceof JestHttpClient ? ((JestHttpClient)client).execute(request, requestConfig) : client.execute(request);
        }
        catch (IOException e) {
            throw new ElasticsearchException(errorMessage.get(), (Throwable)e);
        }
        if (result.isSucceeded()) {
            return (T)result;
        }
        throw JestUtils.specificException(errorMessage, result.getJsonObject().path("error"));
    }

    public static <T extends JestResult> T execute(JestClient client, Action<T> request, Supplier<String> errorMessage) {
        return JestUtils.execute(client, null, request, errorMessage);
    }

    public static ElasticsearchException specificException(Supplier<String> errorMessage, JsonNode errorNode) {
        JsonNode rootCauses = errorNode.path("root_cause");
        ArrayList<String> reasons = new ArrayList<String>(rootCauses.size());
        for (JsonNode rootCause : rootCauses) {
            JsonNode type;
            JsonNode reason = rootCause.path("reason");
            if (reason.isTextual()) {
                reasons.add(reason.asText());
            }
            if (!(type = rootCause.path("type")).isTextual()) continue;
            switch (type.asText()) {
                case "query_parsing_exception": {
                    return JestUtils.buildQueryParsingException(errorMessage, rootCause, reasons);
                }
                case "index_not_found_exception": {
                    String indexName = rootCause.path("resource.id").asText();
                    return JestUtils.buildIndexNotFoundException(errorMessage, indexName);
                }
                case "illegal_argument_exception": {
                    String reasonText = reason.asText();
                    if (!reasonText.startsWith("Expected numeric type on field")) break;
                    return JestUtils.buildFieldTypeException(errorMessage, reasonText);
                }
            }
        }
        if (reasons.isEmpty()) {
            return new ElasticsearchException(errorMessage.get(), Collections.singletonList(errorNode.toString()));
        }
        return new ElasticsearchException(errorMessage.get(), reasons);
    }

    private static FieldTypeException buildFieldTypeException(Supplier<String> errorMessage, String reason) {
        return new FieldTypeException(errorMessage.get(), reason);
    }

    private static QueryParsingException buildQueryParsingException(Supplier<String> errorMessage, JsonNode rootCause, List<String> reasons) {
        JsonNode lineJson = rootCause.path("line");
        Integer line = lineJson.isInt() ? Integer.valueOf(lineJson.asInt()) : null;
        JsonNode columnJson = rootCause.path("col");
        Integer column = columnJson.isInt() ? Integer.valueOf(columnJson.asInt()) : null;
        String index = rootCause.path("index").asText(null);
        return new QueryParsingException(errorMessage.get(), line, column, index, reasons);
    }

    private static IndexNotFoundException buildIndexNotFoundException(Supplier<String> errorMessage, String index) {
        return new IndexNotFoundException(errorMessage.get(), Collections.singletonList("Index not found for query: " + index + ". Try recalculating your index ranges."));
    }
}

