/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.cluster.jest.tasks;

import io.searchbox.action.AbstractAction;
import io.searchbox.action.AbstractMultiINodeActionBuilder;
import io.searchbox.action.GenericResultAbstractAction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Nullable;

public class GetTasks
extends GenericResultAbstractAction {
    @Nullable
    private final String taskId;

    protected GetTasks(Builder builder, @Nullable String taskId) {
        super((AbstractAction.Builder)builder);
        this.taskId = taskId;
        this.setURI(this.buildURI());
    }

    protected String buildURI() {
        String baseUri = super.buildURI() + "/_tasks";
        if (this.taskId != null) {
            try {
                return baseUri + "/" + URLEncoder.encode(this.taskId, "utf-8");
            }
            catch (UnsupportedEncodingException ignored) {
                return null;
            }
        }
        return baseUri;
    }

    public String getRestMethodName() {
        return "GET";
    }

    public static class Builder
    extends AbstractMultiINodeActionBuilder<GetTasks, Builder> {
        private String taskId;

        public Builder() {
            this(null);
        }

        public Builder(String taskId) {
            this.taskId = taskId;
        }

        public Builder waitForCompletion(boolean waitForCompletion) {
            return (Builder)((Object)this.setParameter("wait_for_completion", waitForCompletion));
        }

        public Builder timeout(String timeout) {
            return (Builder)((Object)this.setParameter("timeout", timeout));
        }

        public Builder actions(String actionFilter) {
            return (Builder)((Object)this.setParameter("actions", actionFilter));
        }

        public Builder detailed(boolean detailed) {
            return (Builder)((Object)this.setParameter("detailed", detailed));
        }

        public Builder ofParentTaskId(String parentTaskId) {
            return (Builder)((Object)this.setParameter("parent_task_id", parentTaskId));
        }

        public GetTasks build() {
            String joinedNodes = this.getJoinedNodes();
            if (!"_all".equals(joinedNodes)) {
                this.setParameter("nodes", joinedNodes);
            }
            return new GetTasks(this, this.taskId);
        }
    }
}

