/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indices;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.eventbus.EventBus;
import com.google.common.primitives.Ints;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.cluster.Health;
import io.searchbox.cluster.State;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import io.searchbox.core.Cat;
import io.searchbox.core.CatResult;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.SearchScroll;
import io.searchbox.core.search.aggregation.FilterAggregation;
import io.searchbox.core.search.aggregation.MaxAggregation;
import io.searchbox.core.search.aggregation.MinAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import io.searchbox.indices.CloseIndex;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.DeleteIndex;
import io.searchbox.indices.Flush;
import io.searchbox.indices.ForceMerge;
import io.searchbox.indices.OpenIndex;
import io.searchbox.indices.Stats;
import io.searchbox.indices.aliases.AddAliasMapping;
import io.searchbox.indices.aliases.AliasMapping;
import io.searchbox.indices.aliases.GetAliases;
import io.searchbox.indices.aliases.ModifyAliases;
import io.searchbox.indices.aliases.RemoveAliasMapping;
import io.searchbox.indices.settings.GetSettings;
import io.searchbox.indices.settings.UpdateSettings;
import io.searchbox.indices.template.DeleteTemplate;
import io.searchbox.indices.template.PutTemplate;
import io.searchbox.params.SearchType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import org.apache.http.client.config.RequestConfig;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.IndexMapping;
import org.graylog2.indexer.IndexMappingFactory;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.cluster.jest.JestUtils;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indices.TooManyAliasesException;
import org.graylog2.indexer.indices.events.IndicesClosedEvent;
import org.graylog2.indexer.indices.events.IndicesDeletedEvent;
import org.graylog2.indexer.indices.events.IndicesReopenedEvent;
import org.graylog2.indexer.indices.stats.IndexStatistics;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.indexer.searches.IndexRangeStats;
import org.graylog2.plugin.system.NodeId;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Indices {
    private static final Logger LOG = LoggerFactory.getLogger(Indices.class);
    private static final String REOPENED_ALIAS_SUFFIX = "_reopened";
    private final JestClient jestClient;
    private final ObjectMapper objectMapper;
    private final IndexMappingFactory indexMappingFactory;
    private final Messages messages;
    private final NodeId nodeId;
    private final AuditEventSender auditEventSender;
    private final EventBus eventBus;

    @Inject
    public Indices(JestClient jestClient, ObjectMapper objectMapper, IndexMappingFactory indexMappingFactory, Messages messages, NodeId nodeId, AuditEventSender auditEventSender, EventBus eventBus) {
        this.jestClient = jestClient;
        this.objectMapper = objectMapper;
        this.indexMappingFactory = indexMappingFactory;
        this.messages = messages;
        this.nodeId = nodeId;
        this.auditEventSender = auditEventSender;
        this.eventBus = eventBus;
    }

    public void move(String source, String target) {
        SearchScroll scrollRequest;
        Object scrollResult;
        JsonNode scrollHits;
        String query = SearchSourceBuilder.searchSource().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(350).sort((SortBuilder)SortBuilders.fieldSort((String)"_doc")).toString();
        Search request = ((Search.Builder)((Search.Builder)new Search.Builder(query).setParameter("scroll", (Object)"10s")).addIndex(source)).build();
        SearchResult searchResult = (SearchResult)JestUtils.execute(this.jestClient, request, () -> "Couldn't process search query response");
        String scrollId = searchResult.getJsonObject().path("_scroll_id").asText(null);
        if (scrollId == null) {
            throw new ElasticsearchException("Couldn't find scroll ID in search query response");
        }
        TypeReference<Map<String, Object>> type = new TypeReference<Map<String, Object>>(){};
        while ((scrollHits = (scrollResult = JestUtils.execute(this.jestClient, scrollRequest = new SearchScroll.Builder(scrollId, "1m").build(), () -> "Couldn't process result of scroll query")).getJsonObject().path("hits").path("hits")).size() != 0) {
            Bulk.Builder bulkRequestBuilder = new Bulk.Builder();
            for (JsonNode jsonElement : scrollHits) {
                Map<String, Object> doc = Optional.ofNullable(jsonElement.path("_source")).map(arg_0 -> this.lambda$move$2((TypeReference)type, arg_0)).orElse(Collections.emptyMap());
                String id = (String)doc.remove("_id");
                bulkRequestBuilder.addAction((BulkableAction)this.messages.prepareIndexRequest(target, doc, id));
            }
            bulkRequestBuilder.setParameter("consistency", (Object)"one");
            BulkResult bulkResult = (BulkResult)JestUtils.execute(this.jestClient, bulkRequestBuilder.build(), () -> "Couldn't bulk index messages into index " + target);
            boolean hasFailedItems = !bulkResult.getFailedItems().isEmpty();
            LOG.info("Moving index <{}> to <{}>: Bulk indexed {} messages, took {} ms, failures: {}", new Object[]{source, target, bulkResult.getItems().size(), bulkResult.getJsonObject().path("took").asLong(), hasFailedItems});
            if (!hasFailedItems) continue;
            throw new ElasticsearchException("Failed to move a message. Check your indexer log.");
        }
    }

    public void delete(String indexName) {
        JestUtils.execute(this.jestClient, new DeleteIndex.Builder(indexName).build(), () -> "Couldn't delete index " + indexName);
        this.eventBus.post((Object)IndicesDeletedEvent.create(indexName));
    }

    public void close(String indexName) {
        if (this.isReopened(indexName)) {
            JestUtils.execute(this.jestClient, new ModifyAliases.Builder((AliasMapping)new RemoveAliasMapping.Builder(indexName, indexName + REOPENED_ALIAS_SUFFIX).build()).build(), () -> "Couldn't remove reopened alias for index " + indexName + " before closing.");
        }
        JestUtils.execute(this.jestClient, new CloseIndex.Builder(indexName).build(), () -> "Couldn't close index " + indexName);
        this.eventBus.post((Object)IndicesClosedEvent.create(indexName));
    }

    public long numberOfMessages(String indexName) throws IndexNotFoundException {
        return this.indexStats(indexName).path("primaries").path("docs").path("count").asLong();
    }

    private JsonNode getAllWithShardLevel(Collection<String> indices) {
        Stats request = ((Stats.Builder)((Stats.Builder)new Stats.Builder().addIndex(indices)).setParameter("level", (Object)"shards")).build();
        Object jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't fetch index stats of indices " + indices);
        JsonNode responseJson = jestResult.getJsonObject();
        int failedShards = responseJson.path("_shards").path("failed").asInt();
        if (failedShards > 0) {
            throw new ElasticsearchException("Index stats response contains failed shards, response is incomplete");
        }
        return responseJson.path("indices");
    }

    public JsonNode getIndexStats(IndexSet indexSet) {
        return this.getIndexStats(Collections.singleton(indexSet.getIndexWildcard()));
    }

    private JsonNode getIndexStats(Collection<String> indices) {
        Stats request = ((Stats.Builder)new Stats.Builder().addIndex(indices)).docs(true).store(true).build();
        Object jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't check stats of indices " + indices);
        return jestResult.getJsonObject().path("indices");
    }

    private JsonNode indexStats(String indexName) {
        Stats request = ((Stats.Builder)new Stats.Builder().addIndex(indexName)).build();
        Object jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't check stats of index " + indexName);
        return jestResult.getJsonObject().path("indices").path(indexName);
    }

    private JsonNode indexStatsWithShardLevel(String indexName) {
        Stats request = ((Stats.Builder)((Stats.Builder)((Stats.Builder)new Stats.Builder().addIndex(indexName)).setParameter("level", (Object)"shards")).ignoreUnavailable(true)).build();
        Object jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't check stats of index " + indexName);
        return jestResult.getJsonObject().path("indices").path(indexName);
    }

    public boolean exists(String indexName) {
        try {
            JestResult result = this.jestClient.execute((Action)((GetSettings.Builder)new GetSettings.Builder().addIndex(indexName)).build());
            return result.isSucceeded() && Iterators.contains((Iterator)result.getJsonObject().fieldNames(), (Object)indexName);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Couldn't check existence of index " + indexName, (Throwable)e);
        }
    }

    public boolean aliasExists(String alias) {
        try {
            JestResult result = this.jestClient.execute((Action)((GetSettings.Builder)new GetSettings.Builder().addIndex(alias)).build());
            return result.isSucceeded() && !Iterators.contains((Iterator)result.getJsonObject().fieldNames(), (Object)alias);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Couldn't check existence of alias " + alias, (Throwable)e);
        }
    }

    @NotNull
    public Map<String, Set<String>> getIndexNamesAndAliases(String indexPattern) {
        GetAliases request = ((GetAliases.Builder)((GetAliases.Builder)new GetAliases.Builder().addIndex(indexPattern)).setParameter("expand_wildcards", (Object)"open")).build();
        Object jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't collect aliases for index pattern " + indexPattern);
        ImmutableMap.Builder indexAliasesBuilder = ImmutableMap.builder();
        Iterator it = jestResult.getJsonObject().fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String indexName = (String)entry.getKey();
            JsonNode aliasMetaData = ((JsonNode)entry.getValue()).path("aliases");
            if (!aliasMetaData.isObject()) continue;
            ImmutableSet aliasNames = ImmutableSet.copyOf((Iterator)aliasMetaData.fieldNames());
            indexAliasesBuilder.put((Object)indexName, (Object)aliasNames);
        }
        return indexAliasesBuilder.build();
    }

    public Optional<String> aliasTarget(String alias) throws TooManyAliasesException {
        GetAliases request = new GetAliases.Builder().build();
        Object jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't collect indices for alias " + alias);
        ImmutableSet.Builder indicesBuilder = ImmutableSet.builder();
        Iterator it = jestResult.getJsonObject().fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String indexName = (String)entry.getKey();
            Optional.of((JsonNode)entry.getValue()).map(json -> json.path("aliases")).map(JsonNode::fields).map(ImmutableList::copyOf).filter(aliases -> !aliases.isEmpty()).filter(aliases -> aliases.stream().anyMatch(aliasEntry -> ((String)aliasEntry.getKey()).equals(alias))).ifPresent(x -> indicesBuilder.add((Object)indexName));
        }
        ImmutableSet indices = indicesBuilder.build();
        if (indices.size() > 1) {
            throw new TooManyAliasesException((Set<String>)indices);
        }
        return indices.stream().findFirst();
    }

    public void ensureIndexTemplate(IndexSet indexSet) {
        IndexMapping indexMapping;
        Map<String, Object> template;
        IndexSetConfig indexSetConfig = indexSet.getConfig();
        String templateName = indexSetConfig.indexTemplateName();
        PutTemplate request = new PutTemplate.Builder(templateName, template = (indexMapping = this.indexMappingFactory.createIndexMapping()).messageTemplate(indexSet.getIndexWildcard(), indexSetConfig.indexAnalyzer(), -1)).build();
        Object jestResult = JestUtils.execute(this.jestClient, request, () -> "Unable to create index template " + templateName);
        if (jestResult.isSucceeded()) {
            LOG.info("Successfully created index template {}", (Object)templateName);
        }
    }

    public Map<String, Object> getIndexTemplate(IndexSet indexSet) {
        String indexWildcard = indexSet.getIndexWildcard();
        String analyzer = indexSet.getConfig().indexAnalyzer();
        return this.indexMappingFactory.createIndexMapping().messageTemplate(indexWildcard, analyzer);
    }

    public void deleteIndexTemplate(IndexSet indexSet) {
        String templateName = indexSet.getConfig().indexTemplateName();
        Object result = JestUtils.execute(this.jestClient, new DeleteTemplate.Builder(templateName).build(), () -> "Unable to delete the Graylog index template " + templateName);
        if (result.isSucceeded()) {
            LOG.info("Successfully deleted index template {}", (Object)templateName);
        }
    }

    public boolean create(String indexName, IndexSet indexSet) {
        return this.create(indexName, indexSet, Collections.emptyMap());
    }

    public boolean create(String indexName, IndexSet indexSet, Map<String, Object> customSettings) {
        JestResult jestResult;
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("number_of_shards", indexSet.getConfig().shards());
        settings.put("number_of_replicas", indexSet.getConfig().replicas());
        settings.putAll(customSettings);
        CreateIndex request = new CreateIndex.Builder(indexName).settings(settings).build();
        this.ensureIndexTemplate(indexSet);
        try {
            jestResult = this.jestClient.execute((Action)request);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Couldn't create index " + indexName, (Throwable)e);
        }
        boolean succeeded = jestResult.isSucceeded();
        if (succeeded) {
            this.auditEventSender.success(AuditActor.system(this.nodeId), "server:es_index:create", (Map<String, Object>)ImmutableMap.of((Object)"indexName", (Object)indexName));
        } else {
            LOG.warn("Couldn't create index {}. Error: {}", (Object)indexName, (Object)jestResult.getErrorMessage());
            this.auditEventSender.failure(AuditActor.system(this.nodeId), "server:es_index:create", (Map<String, Object>)ImmutableMap.of((Object)"indexName", (Object)indexName));
        }
        return succeeded;
    }

    public Map<String, Set<String>> getAllMessageFieldsForIndices(String[] writeIndexWildcards) {
        String indices = String.join((CharSequence)",", writeIndexWildcards);
        State request = new State.Builder().indices(indices).withMetadata().build();
        Object jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't read cluster state for indices " + indices);
        JsonNode indicesJson = this.getClusterStateIndicesMetadata(jestResult.getJsonObject());
        ImmutableMap.Builder fields = ImmutableMap.builder();
        Iterator it = indicesJson.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String indexName = (String)entry.getKey();
            ImmutableSet fieldNames = ImmutableSet.copyOf((Iterator)((JsonNode)entry.getValue()).path("mappings").path("message").path("properties").fieldNames());
            if (fieldNames.isEmpty()) continue;
            fields.put((Object)indexName, (Object)fieldNames);
        }
        return fields.build();
    }

    public Set<String> getAllMessageFields(String[] writeIndexWildcards) {
        Map<String, Set<String>> fieldsForIndices = this.getAllMessageFieldsForIndices(writeIndexWildcards);
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Set<String> fields : fieldsForIndices.values()) {
            result.addAll(fields);
        }
        return result.build();
    }

    public void setReadOnly(String index) {
        ImmutableMap settings = ImmutableMap.of((Object)"index", (Object)ImmutableMap.of((Object)"blocks", (Object)ImmutableMap.of((Object)"write", (Object)true, (Object)"read", (Object)false, (Object)"metadata", (Object)false)));
        UpdateSettings request = ((UpdateSettings.Builder)new UpdateSettings.Builder((Object)settings).addIndex(index)).build();
        JestUtils.execute(this.jestClient, request, () -> "Couldn't set index " + index + " to read-only");
    }

    public void flush(String index) {
        JestUtils.execute(this.jestClient, ((Flush.Builder)new Flush.Builder().addIndex(index)).force().build(), () -> "Couldn't flush index " + index);
    }

    public void reopenIndex(String index) {
        this.markIndexReopened(index);
        this.openIndex(index);
    }

    public String markIndexReopened(String index) {
        String aliasName = index + REOPENED_ALIAS_SUFFIX;
        ModifyAliases request = new ModifyAliases.Builder((AliasMapping)new AddAliasMapping.Builder(index, aliasName).build()).build();
        JestUtils.execute(this.jestClient, request, () -> "Couldn't create reopened alias for index " + index);
        return aliasName;
    }

    private void openIndex(String index) {
        JestUtils.execute(this.jestClient, new OpenIndex.Builder(index).build(), () -> "Couldn't open index " + index);
        this.eventBus.post((Object)IndicesReopenedEvent.create(index));
    }

    public boolean isReopened(String indexName) {
        Optional<String> aliasTarget = this.aliasTarget(indexName + REOPENED_ALIAS_SUFFIX);
        return aliasTarget.map(target -> target.equals(indexName)).orElse(false);
    }

    public Map<String, Boolean> areReopened(Collection<String> indices) {
        return indices.stream().collect(Collectors.toMap(Function.identity(), this::isReopened));
    }

    public Set<String> getClosedIndices(Collection<String> indices) {
        JsonNode catIndices = this.catIndices(indices, "index", "status");
        ImmutableSet.Builder closedIndices = ImmutableSet.builder();
        for (JsonNode jsonElement : catIndices) {
            if (!jsonElement.isObject()) continue;
            String index = jsonElement.path("index").asText(null);
            String status = jsonElement.path("status").asText(null);
            if (index == null || !"close".equals(status)) continue;
            closedIndices.add((Object)index);
        }
        return closedIndices.build();
    }

    public Set<String> getClosedIndices(IndexSet indexSet) {
        return this.getClosedIndices(Collections.singleton(indexSet.getIndexWildcard()));
    }

    public boolean isClosed(String indexName) {
        return this.getClosedIndices(Collections.singleton(indexName)).contains(indexName);
    }

    private JsonNode catIndices(Collection<String> indices, String ... fields) {
        String fieldNames = String.join((CharSequence)",", fields);
        Cat request = ((Cat.IndicesBuilder)((Cat.IndicesBuilder)new Cat.IndicesBuilder().addIndex(indices)).setParameter("h", (Object)fieldNames)).build();
        CatResult response = (CatResult)JestUtils.execute(this.jestClient, request, () -> "Unable to read information for indices " + indices);
        return response.getJsonObject().path("result");
    }

    private JsonNode getClusterStateIndicesMetadata(JsonNode clusterStateJson) {
        return clusterStateJson.path("metadata").path("indices");
    }

    public Set<String> getReopenedIndices(Collection<String> indices) {
        return indices.stream().filter(this::isReopened).collect(Collectors.toSet());
    }

    public Set<String> getReopenedIndices(IndexSet indexSet) {
        return this.getReopenedIndices(Collections.singleton(indexSet.getIndexWildcard()));
    }

    public Optional<IndexStatistics> getIndexStats(String index) {
        JsonNode indexStats = this.indexStatsWithShardLevel(index);
        return indexStats.isMissingNode() ? Optional.empty() : Optional.of(this.buildIndexStatistics(index, indexStats));
    }

    private IndexStatistics buildIndexStatistics(String index, JsonNode indexStats) {
        return IndexStatistics.create(index, indexStats);
    }

    public Optional<Long> getStoreSizeInBytes(String index) {
        Stats request = ((Stats.Builder)new Stats.Builder().addIndex(index)).store(true).build();
        Object jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't check store stats of index " + index);
        JsonNode sizeInBytes = jestResult.getJsonObject().path("indices").path(index).path("primaries").path("store").path("size_in_bytes");
        return Optional.of(sizeInBytes).filter(JsonNode::isNumber).map(JsonNode::asLong);
    }

    public Set<IndexStatistics> getIndicesStats(IndexSet indexSet) {
        return this.getIndicesStats(Collections.singleton(indexSet.getIndexWildcard()));
    }

    public Set<IndexStatistics> getIndicesStats(Collection<String> indices) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        JsonNode allWithShardLevel = this.getAllWithShardLevel(indices);
        Iterator fields = allWithShardLevel.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String index = (String)entry.getKey();
            JsonNode indexStats = (JsonNode)entry.getValue();
            if (!indexStats.isObject()) continue;
            result.add((Object)this.buildIndexStatistics(index, indexStats));
        }
        return result.build();
    }

    public void cycleAlias(String aliasName, String targetIndex) {
        AddAliasMapping addAliasMapping = new AddAliasMapping.Builder(targetIndex, aliasName).build();
        JestUtils.execute(this.jestClient, new ModifyAliases.Builder((AliasMapping)addAliasMapping).build(), () -> "Couldn't point alias " + aliasName + " to index " + targetIndex);
    }

    public void cycleAlias(String aliasName, String targetIndex, String oldIndex) {
        AddAliasMapping addAliasMapping = new AddAliasMapping.Builder(targetIndex, aliasName).build();
        RemoveAliasMapping removeAliasMapping = new RemoveAliasMapping.Builder(oldIndex, aliasName).build();
        ModifyAliases request = new ModifyAliases.Builder(Arrays.asList(removeAliasMapping, addAliasMapping)).build();
        JestUtils.execute(this.jestClient, request, () -> "Couldn't switch alias " + aliasName + " from index " + oldIndex + " to index " + targetIndex);
    }

    public void removeAliases(String alias, Set<String> indices) {
        RemoveAliasMapping removeAliasMapping = new RemoveAliasMapping.Builder((List)ImmutableList.copyOf(indices), alias).build();
        ModifyAliases request = new ModifyAliases.Builder((AliasMapping)removeAliasMapping).build();
        JestUtils.execute(this.jestClient, request, () -> "Couldn't remove alias " + alias + " from indices " + indices);
    }

    public void optimizeIndex(String index, int maxNumSegments, Duration timeout) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(Ints.saturatedCast((long)timeout.toMilliseconds())).build();
        ForceMerge request = ((ForceMerge.Builder)new ForceMerge.Builder().addIndex(index)).maxNumSegments((Number)maxNumSegments).flush(true).onlyExpungeDeletes(false).build();
        JestUtils.execute(this.jestClient, requestConfig, request, () -> "Couldn't force merge index " + index);
    }

    public Health.Status waitForRecovery(String index) {
        return this.waitForStatus(index, Health.Status.YELLOW);
    }

    private Health.Status waitForStatus(String index, Health.Status clusterHealthStatus) {
        LOG.debug("Waiting until index health status of index {} is {}", (Object)index, (Object)clusterHealthStatus);
        Health request = ((Health.Builder)new Health.Builder().addIndex(index)).waitForStatus(clusterHealthStatus).build();
        Object jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't read health status for index " + index);
        String status = jestResult.getJsonObject().path("status").asText();
        return Health.Status.valueOf((String)status.toUpperCase(Locale.ENGLISH));
    }

    public Optional<DateTime> indexCreationDate(String index) {
        GetSettings request = ((GetSettings.Builder)((GetSettings.Builder)new GetSettings.Builder().addIndex(index)).ignoreUnavailable(true)).build();
        Object jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't read settings of index " + index);
        return Optional.of(jestResult.getJsonObject().path(index).path("settings").path("index").path("creation_date")).filter(JsonNode::isValueNode).map(JsonNode::asLong).map(creationDate -> new DateTime(creationDate, DateTimeZone.UTC));
    }

    public IndexRangeStats indexRangeStatsOfIndex(String index) {
        SearchResult result;
        FilterAggregation f;
        FilterAggregationBuilder builder = (FilterAggregationBuilder)((FilterAggregationBuilder)((FilterAggregationBuilder)AggregationBuilders.filter((String)"agg").filter((QueryBuilder)QueryBuilders.existsQuery((String)"timestamp")).subAggregation((AbstractAggregationBuilder)AggregationBuilders.min((String)"ts_min").field("timestamp"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.max((String)"ts_max").field("timestamp"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.terms((String)"streams").field("streams"));
        String query = SearchSourceBuilder.searchSource().aggregation((AbstractAggregationBuilder)builder).size(0).toString();
        Search request = ((Search.Builder)((Search.Builder)new Search.Builder(query).addIndex(index)).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).ignoreUnavailable(true)).build();
        if (LOG.isDebugEnabled()) {
            String data = "{}";
            try {
                data = request.getData(this.objectMapper.copy().enable(SerializationFeature.INDENT_OUTPUT));
            }
            catch (IOException e) {
                LOG.debug("Couldn't pretty print request payload", (Throwable)e);
            }
            LOG.debug("Index range query: _search/{}: {}", (Object)index, (Object)data);
        }
        if ((f = (result = (SearchResult)JestUtils.execute(this.jestClient, request, () -> "Couldn't build index range of index " + index)).getAggregations().getFilterAggregation("agg")) == null) {
            throw new IndexNotFoundException("Couldn't build index range of index " + index + " because it doesn't exist.");
        }
        if (f.getCount() == 0L) {
            LOG.debug("No documents with attribute \"timestamp\" found in index <{}>", (Object)index);
            return IndexRangeStats.EMPTY;
        }
        MinAggregation minAgg = f.getMinAggregation("ts_min");
        DateTime min = new DateTime(minAgg.getMin().longValue(), DateTimeZone.UTC);
        MaxAggregation maxAgg = f.getMaxAggregation("ts_max");
        DateTime max = new DateTime(maxAgg.getMax().longValue(), DateTimeZone.UTC);
        TermsAggregation streams = f.getTermsAggregation("streams");
        List<String> streamIds = streams.getBuckets().stream().map(TermsAggregation.Entry::getKeyAsString).collect(Collectors.toList());
        return IndexRangeStats.create(min, max, streamIds);
    }

    private /* synthetic */ Map lambda$move$2(TypeReference type, JsonNode sourceJson) {
        return (Map)this.objectMapper.convertValue((Object)sourceJson, type);
    }
}

