/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.google.common.base.MoreObjects;
import java.util.Set;
import javax.inject.Inject;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.cluster.NodeFileDescriptorStats;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerClusterCheckerThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexerClusterCheckerThread.class);
    private static final int MINIMUM_OPEN_FILES_LIMIT = 64000;
    private final NotificationService notificationService;
    private final Cluster cluster;

    @Inject
    public IndexerClusterCheckerThread(NotificationService notificationService, Cluster cluster) {
        this.notificationService = notificationService;
        this.cluster = cluster;
    }

    @Override
    public void doRun() {
        if (!this.notificationService.isFirst(Notification.Type.ES_OPEN_FILES)) {
            return;
        }
        if (!this.cluster.health().isPresent()) {
            LOG.info("Indexer not fully initialized yet. Skipping periodic cluster check.");
            return;
        }
        boolean allHigher = true;
        Set<NodeFileDescriptorStats> fileDescriptorStats = this.cluster.getFileDescriptorStats();
        for (NodeFileDescriptorStats nodeFileDescriptorStats : fileDescriptorStats) {
            String name = nodeFileDescriptorStats.name();
            String ip = nodeFileDescriptorStats.ip();
            String host = nodeFileDescriptorStats.host();
            long maxFileDescriptors = nodeFileDescriptorStats.fileDescriptorMax().orElse(-1L);
            if (maxFileDescriptors == -1L || maxFileDescriptors >= 64000L) continue;
            String ipOrHostName = (String)MoreObjects.firstNonNull((Object)host, (Object)ip);
            Notification notification = this.notificationService.buildNow().addType(Notification.Type.ES_OPEN_FILES).addSeverity(Notification.Severity.URGENT).addDetail("hostname", ipOrHostName).addDetail("max_file_descriptors", maxFileDescriptors);
            if (this.notificationService.publishIfFirst(notification)) {
                LOG.warn("Indexer node <{}> ({}) open file limit is too low: [{}]. Set it to at least {}.", new Object[]{name, ipOrHostName, maxFileDescriptors, 64000});
            }
            allHigher = false;
        }
        if (allHigher) {
            Notification notification = this.notificationService.build().addType(Notification.Type.ES_OPEN_FILES);
            this.notificationService.fixed(notification);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 30;
    }
}

