/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer.responses;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.rest.resources.system.indexer.responses.AutoValue_IndexSetSummary;

@JsonAutoDetect
@AutoValue
public abstract class IndexSetSummary {
    @JsonProperty(value="id")
    @Nullable
    public abstract String id();

    @JsonProperty(value="title")
    @NotBlank
    public abstract String title();

    @JsonProperty(value="description")
    @Nullable
    public abstract String description();

    @JsonProperty(value="default")
    public abstract boolean isDefault();

    @JsonProperty(value="writable")
    public abstract boolean isWritable();

    @JsonProperty(value="index_prefix")
    @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
    public abstract @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") String indexPrefix();

    @JsonProperty(value="shards")
    @Min(value=1L)
    public abstract @Min(value=1L) int shards();

    @JsonProperty(value="replicas")
    @Min(value=0L)
    public abstract @Min(value=0L) int replicas();

    @JsonProperty(value="rotation_strategy_class")
    @NotNull
    public abstract String rotationStrategyClass();

    @JsonProperty(value="rotation_strategy")
    @NotNull
    public abstract RotationStrategyConfig rotationStrategy();

    @JsonProperty(value="retention_strategy_class")
    @NotNull
    public abstract String retentionStrategyClass();

    @JsonProperty(value="retention_strategy")
    @NotNull
    public abstract RetentionStrategyConfig retentionStrategy();

    @JsonProperty(value="creation_date")
    @NotNull
    public abstract ZonedDateTime creationDate();

    @JsonProperty(value="index_analyzer")
    @NotBlank
    public abstract String indexAnalyzer();

    @JsonProperty(value="index_optimization_max_num_segments")
    @Min(value=1L)
    public abstract @Min(value=1L) int indexOptimizationMaxNumSegments();

    @JsonProperty(value="index_optimization_disabled")
    public abstract boolean indexOptimizationDisabled();

    @JsonCreator
    public static IndexSetSummary create(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="title") @NotBlank String title, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="default") boolean isDefault, @JsonProperty(value="writable") boolean isWritable, @JsonProperty(value="index_prefix") @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") String indexPrefix, @JsonProperty(value="shards") @Min(value=1L) @Min(value=1L) int shards, @JsonProperty(value="replicas") @Min(value=0L) @Min(value=0L) int replicas, @JsonProperty(value="rotation_strategy_class") @NotNull String rotationStrategyClass, @JsonProperty(value="rotation_strategy") @NotNull RotationStrategyConfig rotationStrategy, @JsonProperty(value="retention_strategy_class") @NotNull String retentionStrategyClass, @JsonProperty(value="retention_strategy") @NotNull RetentionStrategyConfig retentionStrategy, @JsonProperty(value="creation_date") @NotNull ZonedDateTime creationDate, @JsonProperty(value="index_analyzer") @NotBlank String indexAnalyzer, @JsonProperty(value="index_optimization_max_num_segments") @Min(value=1L) @Min(value=1L) int indexOptimizationMaxNumSegments, @JsonProperty(value="index_optimization_disabled") boolean indexOptimizationDisabled) {
        return new AutoValue_IndexSetSummary(id, title, description, isDefault, isWritable, indexPrefix, shards, replicas, rotationStrategyClass, rotationStrategy, retentionStrategyClass, retentionStrategy, creationDate, indexAnalyzer, indexOptimizationMaxNumSegments, indexOptimizationDisabled);
    }

    public static IndexSetSummary fromIndexSetConfig(IndexSetConfig indexSet, boolean isDefault) {
        return IndexSetSummary.create(indexSet.id(), indexSet.title(), indexSet.description(), isDefault, indexSet.isWritable(), indexSet.indexPrefix(), indexSet.shards(), indexSet.replicas(), indexSet.rotationStrategyClass(), indexSet.rotationStrategy(), indexSet.retentionStrategyClass(), indexSet.retentionStrategy(), indexSet.creationDate(), indexSet.indexAnalyzer(), indexSet.indexOptimizationMaxNumSegments(), indexSet.indexOptimizationDisabled());
    }

    public IndexSetConfig toIndexSetConfig() {
        return IndexSetConfig.builder().id(this.id()).title(this.title()).description(this.description()).isWritable(this.isWritable()).indexPrefix(this.indexPrefix()).shards(this.shards()).replicas(this.replicas()).rotationStrategyClass(this.rotationStrategyClass()).rotationStrategy(this.rotationStrategy()).retentionStrategyClass(this.retentionStrategyClass()).retentionStrategy(this.retentionStrategy()).creationDate(this.creationDate()).indexAnalyzer(this.indexAnalyzer()).indexTemplateName(this.indexPrefix() + "-template").indexOptimizationMaxNumSegments(this.indexOptimizationMaxNumSegments()).indexOptimizationDisabled(this.indexOptimizationDisabled()).build();
    }
}

