/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.rest;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.map.search.MapDataSearch;
import org.graylog.plugins.map.search.MapDataSearchRequest;
import org.graylog.plugins.map.search.MapDataSearchResult;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.decorators.DecoratorProcessor;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.resources.search.SearchResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="MapWidget", description="Get map data")
@Path(value="/search/mapdata")
public class MapDataResource
extends SearchResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(MapDataResource.class);
    private final MapDataSearch search;

    @Inject
    public MapDataResource(MapDataSearch search, Searches searches, ClusterConfigService clusterConfigService, DecoratorProcessor decoratorProcessor) {
        super(searches, clusterConfigService, decoratorProcessor);
        this.search = search;
    }

    @POST
    @Timed
    @ApiOperation(value="Get map data")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoAuditEvent(value="only used to fetch map data, no changes made in the system")
    public MapDataSearchResult mapData(@ApiParam(name="JSON body", required=true) MapDataSearchRequest request) {
        String filter = "streams:" + request.streamId();
        switch (request.timerange().type()) {
            case "absolute": {
                this.checkSearchPermission(filter, "searches:absolute");
                break;
            }
            case "relative": {
                this.checkSearchPermission(filter, "searches:relative");
                break;
            }
            case "keyword": {
                this.checkSearchPermission(filter, "searches:keyword");
            }
        }
        try {
            return this.search.searchMapData(request);
        }
        catch (MapDataSearch.ValueTypeException e) {
            LOG.error("Map data query failed: {}", (Object)e.getMessage());
            throw new BadRequestException(e.getMessage());
        }
    }
}

