/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.expressions;

import java.util.Collections;
import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BaseExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;

public class MessageRefExpression
extends BaseExpression {
    private final Expression fieldExpr;

    public MessageRefExpression(Token start, Expression fieldExpr) {
        super(start);
        this.fieldExpr = fieldExpr;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public Object evaluateUnsafe(EvaluationContext context) {
        Object fieldName = this.fieldExpr.evaluateUnsafe(context);
        if (fieldName == null) {
            return null;
        }
        return context.currentMessage().getField(fieldName.toString());
    }

    @Override
    public Class getType() {
        return Object.class;
    }

    public String toString() {
        return "$message." + this.fieldExpr.toString();
    }

    public Expression getFieldExpr() {
        return this.fieldExpr;
    }

    @Override
    public Iterable<Expression> children() {
        return Collections.singleton(this.fieldExpr);
    }
}

