/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.parser;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.ast.functions.Function;

public class FunctionRegistry {
    private final Map<String, Function<?>> functions;

    @Inject
    public FunctionRegistry(Map<String, Function<?>> functions) {
        this.functions = functions;
    }

    public Function<?> resolve(String name) {
        return this.functions.get(name);
    }

    public Function<?> resolveOrError(String name) {
        Function<?> function = this.resolve(name);
        if (function == null) {
            return Function.ERROR_FUNCTION;
        }
        return function;
    }

    public Collection<Function<?>> all() {
        return this.functions.values().stream().collect(Collectors.toList());
    }
}

