/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.migrations;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.graylog.plugins.sidecar.rest.models.Collector;
import org.graylog.plugins.sidecar.services.CollectorService;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20180212165000_AddDefaultCollectors
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20180212165000_AddDefaultCollectors.class);
    private final CollectorService collectorService;
    private final MongoCollection<Document> collection;

    @Inject
    public V20180212165000_AddDefaultCollectors(CollectorService collectorService, MongoConnection mongoConnection) {
        this.collectorService = collectorService;
        this.collection = mongoConnection.getMongoDatabase().getCollection("sidecar_collectors");
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2018-02-12T16:50:00Z");
    }

    @Override
    public void upgrade() {
        this.removeConfigPath();
        String beatsPreambel = "# Needed for Graylog\nfields_under_root: true\nfields.collector_node_id: ${sidecar.nodeName}\nfields.gl2_source_collector: ${sidecar.nodeId}\n\n";
        this.ensureCollector("filebeat", "exec", "linux", "/usr/share/filebeat/bin/filebeat", "-c  %s", "test config -c %s", "# Needed for Graylog\nfields_under_root: true\nfields.collector_node_id: ${sidecar.nodeName}\nfields.gl2_source_collector: ${sidecar.nodeId}\n\nfilebeat.inputs:\n- input_type: log\n  paths:\n    - /var/log/*.log\n  type: log\noutput.logstash:\n   hosts: [\"192.168.1.1:5044\"]\npath:\n  data: /var/lib/graylog-sidecar/collectors/filebeat/data\n  logs: /var/lib/graylog-sidecar/collectors/filebeat/log");
        this.ensureCollector("winlogbeat", "svc", "windows", "C:\\Program Files\\Graylog\\sidecar\\winlogbeat.exe", "-c \"%s\"", "test config -c \"%s\"", "# Needed for Graylog\nfields_under_root: true\nfields.collector_node_id: ${sidecar.nodeName}\nfields.gl2_source_collector: ${sidecar.nodeId}\n\noutput.logstash:\n   hosts: [\"192.168.1.1:5044\"]\npath:\n  data: C:\\Program Files\\Graylog\\sidecar\\cache\\winlogbeat\\data\n  logs: C:\\Program Files\\Graylog\\sidecar\\logs\ntags:\n - windows\nwinlogbeat:\n  event_logs:\n   - name: Application\n   - name: System\n   - name: Security");
        this.ensureCollector("nxlog", "exec", "linux", "/usr/bin/nxlog", "-f -c %s", "-v -c %s", "define ROOT /usr/bin\n\n<Extension gelfExt>\n  Module xm_gelf\n  # Avoid truncation of the short_message field to 64 characters.\n  ShortMessageLength 65536\n</Extension>\n\n<Extension syslogExt>\n  Module xm_syslog\n</Extension>\n\nUser nxlog\nGroup nxlog\n\nModuledir /usr/lib/nxlog/modules\nCacheDir /var/spool/nxlog/data\nPidFile /var/run/nxlog/nxlog.pid\nLogFile /var/log/nxlog/nxlog.log\nLogLevel INFO\n\n\n<Input file>\n\tModule im_file\n\tFile '/var/log/*.log'\n\tPollInterval 1\n\tSavePos\tTrue\n\tReadFromLast True\n\tRecursive False\n\tRenameCheck False\n\tExec $FileName = file_name(); # Send file name with each message\n</Input>\n\n#<Input syslog-udp>\n#\tModule im_udp\n#\tHost 127.0.0.1\n#\tPort 514\n#\tExec parse_syslog_bsd();\n#</Input>\n\n<Output gelf>\n\tModule om_tcp\n\tHost 192.168.1.1\n\tPort 12201\n\tOutputType  GELF_TCP\n\t<Exec>\n\t  # These fields are needed for Graylog\n\t  $gl2_source_collector = '${sidecar.nodeId}';\n\t  $collector_node_id = '${sidecar.nodeName}';\n\t</Exec>\n</Output>\n\n\n<Route route-1>\n  Path file => gelf\n</Route>\n#<Route route-2>\n#  Path syslog-udp => gelf\n#</Route>\n\n\n");
        this.ensureCollector("nxlog", "svc", "windows", "C:\\Program Files (x86)\\nxlog\\nxlog.exe", "-c \"%s\"", "-v -f -c \"%s\"", "define ROOT C:\\Program Files (x86)\\nxlog\n\nModuledir %ROOT%\\modules\nCacheDir %ROOT%\\data\nPidfile %ROOT%\\data\\nxlog.pid\nSpoolDir %ROOT%\\data\nLogFile %ROOT%\\data\\nxlog.log\nLogLevel INFO\n\n<Extension logrotate>\n    Module  xm_fileop\n    <Schedule>\n        When    @daily\n        Exec    file_cycle('%ROOT%\\data\\nxlog.log', 7);\n     </Schedule>\n</Extension>\n\n\n<Extension gelfExt>\n  Module xm_gelf\n  # Avoid truncation of the short_message field to 64 characters.\n  ShortMessageLength 65536\n</Extension>\n\n<Input eventlog>\n        Module im_msvistalog\n        PollInterval 1\n        SavePos True\n        ReadFromLast True\n        \n        #Channel System\n        #<QueryXML>\n        #  <QueryList>\n        #   <Query Id='1'>\n        #    <Select Path='Security'>*[System/Level=4]</Select>\n        #    </Query>\n        #  </QueryList>\n        #</QueryXML>\n</Input>\n\n\n<Input file>\n\tModule im_file\n\tFile 'C:\\Windows\\MyLogDir\\\\*.log'\n\tPollInterval 1\n\tSavePos\tTrue\n\tReadFromLast True\n\tRecursive False\n\tRenameCheck False\n\tExec $FileName = file_name(); # Send file name with each message\n</Input>\n\n\n<Output gelf>\n\tModule om_tcp\n\tHost 192.168.1.1\n\tPort 12201\n\tOutputType  GELF_TCP\n\t<Exec>\n\t  # These fields are needed for Graylog\n\t  $gl2_source_collector = '${sidecar.nodeId}';\n\t  $collector_node_id = '${sidecar.nodeName}';\n\t</Exec>\n</Output>\n\n\n<Route route-1>\n  Path eventlog => gelf\n</Route>\n<Route route-2>\n  Path file => gelf\n</Route>\n\n");
    }

    private void removeConfigPath() {
        FindIterable documentsWithConfigPath = this.collection.find(Filters.exists((String)"configuration_path"));
        for (Document document : documentsWithConfigPath) {
            ObjectId objectId = document.getObjectId((Object)"_id");
            document.remove((Object)"configuration_path");
            UpdateResult updateResult = this.collection.replaceOne(Filters.eq((String)"_id", (Object)objectId), (Object)document);
            if (updateResult.wasAcknowledged()) {
                LOG.debug("Successfully updated document with ID <{}>", (Object)objectId);
                continue;
            }
            LOG.error("Failed to update document with ID <{}>", (Object)objectId);
        }
    }

    @Nullable
    private String ensureCollector(String collectorName, String serviceType, String nodeOperatingSystem, String executablePath, String executeParameters, String validationCommand, String defaultTemplate) {
        Collector collector = null;
        try {
            collector = this.collectorService.findByNameAndOs(collectorName, nodeOperatingSystem);
            if (collector == null) {
                String msg = "Couldn't find collector '{} on {}' fixing it.";
                LOG.error("Couldn't find collector '{} on {}' fixing it.", (Object)collectorName, (Object)nodeOperatingSystem);
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException ignored) {
            LOG.info("{} collector on {} is missing, adding it.", (Object)collectorName, (Object)nodeOperatingSystem);
            Collector newCollector = Collector.create(null, collectorName, serviceType, nodeOperatingSystem, executablePath, executeParameters, validationCommand, defaultTemplate);
            try {
                return this.collectorService.save(newCollector).id();
            }
            catch (Exception e) {
                LOG.error("Can't save collector " + collectorName + ", please restart Graylog to fix this.", (Throwable)e);
            }
        }
        if (collector == null) {
            LOG.error("Unable to access fixed " + collectorName + " collector, please restart Graylog to fix this.");
            return null;
        }
        return collector.id();
    }
}

