/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.decorators;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.template.Template;
import com.floreysoft.jmte.template.VariableDescription;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.decorators.Decorator;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.decorators.SearchResponseDecorator;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.resources.search.responses.SearchResponse;

public class FormatStringDecorator
implements SearchResponseDecorator {
    private static final String CK_FORMAT_STRING = "format_string";
    private static final String CK_REQUIRE_ALL_FIELDS = "require_all_fields";
    private static final String CK_TARGET_FIELD = "target_field";
    private final String targetField;
    private final Template template;
    private final boolean requireAllFields;
    private final List<VariableDescription> usedVariables;

    @Inject
    public FormatStringDecorator(@Assisted Decorator decorator, Engine templateEngine) {
        String formatString = (String)Objects.requireNonNull(decorator.config().get(CK_FORMAT_STRING), "format_string cannot be null");
        this.targetField = (String)Objects.requireNonNull(decorator.config().get(CK_TARGET_FIELD), "target_field cannot be null");
        this.requireAllFields = (Boolean)Objects.requireNonNull(decorator.config().get(CK_REQUIRE_ALL_FIELDS), "require_all_fields cannot be null");
        this.template = Objects.requireNonNull(templateEngine, "templateEngine").getTemplate(formatString);
        this.usedVariables = this.template.getUsedVariableDescriptions();
    }

    @Override
    public SearchResponse apply(SearchResponse searchResponse) {
        List<ResultMessageSummary> summaries = searchResponse.messages().stream().map(summary -> {
            if (this.requireAllFields && !this.usedVariables.stream().allMatch(variable -> summary.message().containsKey(variable.name))) {
                return summary;
            }
            String formattedString = this.template.transform(summary.message(), Locale.ENGLISH);
            if (formattedString == null) {
                return summary;
            }
            Message message = new Message((Map<String, Object>)ImmutableMap.copyOf(summary.message()));
            message.addField(this.targetField, formattedString);
            return summary.toBuilder().message(message.getFields()).build();
        }).collect(Collectors.toList());
        return searchResponse.toBuilder().messages(summaries).build();
    }

    public static class Descriptor
    extends SearchResponseDecorator.Descriptor {
        public Descriptor() {
            super("Format String", "http://docs.graylog.org/", "Format string");
        }
    }

    public static class Config
    implements SearchResponseDecorator.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            return new ConfigurationRequest(){
                {
                    this.addField(new TextField(FormatStringDecorator.CK_FORMAT_STRING, "Format String", "${source} - ${message}", "The format string used to create the concatenated field.", new TextField.Attribute[0]));
                    this.addField(new BooleanField(FormatStringDecorator.CK_REQUIRE_ALL_FIELDS, "Require all fields", false, "Check this if all fields in the format string need to be present in order to apply this decorator."));
                    this.addField(new TextField(FormatStringDecorator.CK_TARGET_FIELD, "Target field", "message", "The message field that will be created with the formatted string.", new TextField.Attribute[0]));
                }
            };
        }
    }

    public static interface Factory
    extends SearchResponseDecorator.Factory {
        @Override
        public FormatStringDecorator create(Decorator var1);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

