/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.github.zafarkhaja.semver.Version;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.IndexMapping;
import org.graylog2.indexer.IndexMapping5;
import org.graylog2.indexer.IndexMapping6;
import org.graylog2.indexer.cluster.Node;

@Singleton
public class IndexMappingFactory {
    private final Node node;

    @Inject
    public IndexMappingFactory(Node node) {
        this.node = node;
    }

    public IndexMapping createIndexMapping() {
        Version elasticsearchVersion = this.node.getVersion().orElseThrow(() -> new ElasticsearchException("Unable to retrieve Elasticsearch version."));
        if (elasticsearchVersion.satisfies("^5.0.0")) {
            return new IndexMapping5();
        }
        if (elasticsearchVersion.satisfies("^6.0.0")) {
            return new IndexMapping6();
        }
        throw new ElasticsearchException("Unsupported Elasticsearch version: " + elasticsearchVersion);
    }
}

