/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.Maps;
import io.searchbox.core.search.aggregation.DateHistogramAggregation;
import io.searchbox.core.search.aggregation.MissingAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog2.indexer.results.IndexQueryResult;
import org.graylog2.indexer.results.TermsResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.joda.time.DateTime;

public class TermsHistogramResult
extends IndexQueryResult {
    private final long size;
    private final Searches.DateHistogramInterval interval;
    private final Map<Long, TermsResult> result;
    private final HashSet<String> terms;
    private AbsoluteRange boundaries;

    public TermsHistogramResult(@Nullable DateHistogramAggregation result, String originalQuery, String builtQuery, long size, long tookMs, Searches.DateHistogramInterval interval, List<String> fields) {
        super(originalQuery, builtQuery, tookMs);
        this.size = size;
        this.interval = interval;
        this.result = Maps.newTreeMap();
        this.terms = new HashSet();
        if (result != null) {
            for (DateHistogramAggregation.DateHistogram histogram : result.getBuckets()) {
                DateTime keyAsDate = new DateTime((Object)histogram.getKey());
                TermsAggregation termsAggregation = histogram.getFilterAggregation("gl2_filter").getTermsAggregation("gl2_terms");
                MissingAggregation missingAgregation = histogram.getMissingAggregation("missing");
                TermsResult termsResult = new TermsResult(termsAggregation, missingAgregation.getMissing(), histogram.getCount(), "", "", tookMs, fields);
                this.terms.addAll(termsResult.getTerms().keySet());
                this.result.put(keyAsDate.getMillis() / 1000L, termsResult);
            }
        }
    }

    public long getSize() {
        return this.size;
    }

    public Searches.DateHistogramInterval getInterval() {
        return this.interval;
    }

    public Map<Long, TermsResult> getResults() {
        return this.result;
    }

    public Set<String> getTerms() {
        return this.terms;
    }

    @Nullable
    public AbsoluteRange getHistogramBoundaries() {
        if (this.boundaries == null) {
            this.boundaries = Tools.extractHistogramBoundaries(this.getBuiltQuery()).orElse(null);
        }
        return this.boundaries;
    }

    public static TermsHistogramResult empty(String originalQuery, String builtQuery, long size, Searches.DateHistogramInterval interval) {
        return new TermsHistogramResult(null, originalQuery, builtQuery, size, 0L, interval, Collections.emptyList());
    }
}

