/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.realm.Realm;
import org.graylog2.cluster.ClusterConfigChangedEvent;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.security.AuthenticationConfig;
import org.graylog2.utilities.LenientExplicitOrdering;

public class OrderedAuthenticatingRealms
extends AbstractCollection<Realm> {
    private final Map<String, AuthenticatingRealm> availableRealms;
    private final ClusterConfigService clusterConfigService;
    private final AtomicReference<List<Realm>> orderedRealms = new AtomicReference();

    @Inject
    public OrderedAuthenticatingRealms(Map<String, AuthenticatingRealm> realms, ClusterConfigService clusterConfigService, EventBus eventBus) {
        this.availableRealms = realms;
        this.clusterConfigService = clusterConfigService;
        eventBus.register((Object)this);
        this.sortRealms();
        Objects.requireNonNull(this.orderedRealms.get());
    }

    @Subscribe
    public void handleOrderingUpdate(ClusterConfigChangedEvent event) {
        if (!AuthenticationConfig.class.getCanonicalName().equals(event.type())) {
            return;
        }
        this.sortRealms();
    }

    private void sortRealms() {
        AuthenticationConfig config = this.clusterConfigService.getOrDefault(AuthenticationConfig.class, AuthenticationConfig.defaultInstance());
        LenientExplicitOrdering<String> ordering = new LenientExplicitOrdering<String>(config.realmOrder());
        ImmutableList newRealmOrder = ordering.immutableSortedCopy(this.availableRealms.keySet());
        this.orderedRealms.set(newRealmOrder.stream().filter(name -> !config.disabledRealms().contains(name)).map(this.availableRealms::get).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public Iterator<Realm> iterator() {
        return this.orderedRealms.get().iterator();
    }

    @Override
    public int size() {
        return this.orderedRealms.get().size();
    }
}

