/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.shared.rest.resources.AutoValue_ProxiedResource_MasterResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public abstract class ProxiedResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ProxiedResource.class);
    protected final String authenticationToken;
    protected final NodeService nodeService;
    protected final RemoteInterfaceProvider remoteInterfaceProvider;
    private final ExecutorService executor;

    protected ProxiedResource(@Context HttpHeaders httpHeaders, NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, ExecutorService executorService) {
        this.nodeService = nodeService;
        this.remoteInterfaceProvider = remoteInterfaceProvider;
        this.executor = executorService;
        List authenticationTokens = httpHeaders.getRequestHeader("Authorization");
        this.authenticationToken = authenticationTokens != null && authenticationTokens.size() >= 1 ? (String)authenticationTokens.get(0) : null;
    }

    protected <RemoteInterfaceType, RemoteCallResponseType> Map<String, Optional<RemoteCallResponseType>> getForAllNodes(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> fn, Function<String, Optional<RemoteInterfaceType>> interfaceProvider) {
        return this.getForAllNodes(fn, interfaceProvider, Function.identity());
    }

    protected <RemoteInterfaceType, FinalResponseType, RemoteCallResponseType> Map<String, Optional<FinalResponseType>> getForAllNodes(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> fn, Function<String, Optional<RemoteInterfaceType>> interfaceProvider, Function<RemoteCallResponseType, FinalResponseType> transformer) {
        Map futures = this.nodeService.allActive().keySet().stream().collect(Collectors.toMap(Function.identity(), node -> ((Optional)interfaceProvider.apply((String)node)).map(r -> this.executor.submit(() -> {
            Call call = (Call)fn.apply(r);
            try {
                Response response = call.execute();
                if (response.isSuccessful()) {
                    return Optional.of(transformer.apply(response.body()));
                }
                LOG.warn("Unable to call {} on node <{}>, result: {}", new Object[]{call.request().url(), node, response.message()});
                return Optional.empty();
            }
            catch (IOException e) {
                LOG.warn("Unable to call {} on node <{}>", new Object[]{call.request().url(), node, e});
                return Optional.empty();
            }
        })).orElse(CompletableFuture.completedFuture(Optional.empty()))));
        return futures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            try {
                return (Optional)((Future)entry.getValue()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug("Couldn't retrieve future", (Throwable)e);
                return Optional.empty();
            }
        }));
    }

    protected <RemoteInterfaceType> Function<String, Optional<RemoteInterfaceType>> createRemoteInterfaceProvider(Class<RemoteInterfaceType> interfaceClass) {
        return nodeId -> {
            try {
                Node targetNode = this.nodeService.byNodeId((String)nodeId);
                return Optional.of(this.remoteInterfaceProvider.get(targetNode, this.authenticationToken, interfaceClass));
            }
            catch (NodeNotFoundException e) {
                LOG.warn("Node <" + nodeId + "> not found while trying to call " + interfaceClass.getName() + " on it.");
                return Optional.empty();
            }
        };
    }

    protected <RemoteInterfaceType, RemoteCallResponseType> MasterResponse<RemoteCallResponseType> requestOnMaster(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> remoteInterfaceFunction, Function<String, Optional<RemoteInterfaceType>> remoteInterfaceProvider) throws IOException {
        Node masterNode = this.nodeService.allActive().values().stream().filter(Node::isMaster).findFirst().orElseThrow(() -> new IllegalStateException("No active master node found"));
        RemoteInterfaceType remoteInterfaceType = remoteInterfaceProvider.apply(masterNode.getNodeId()).orElseThrow(() -> new IllegalStateException("Master node " + masterNode.getNodeId() + " not found"));
        Call<RemoteCallResponseType> call = remoteInterfaceFunction.apply(remoteInterfaceType);
        Response response = call.execute();
        byte[] errorBody = response.errorBody() == null ? null : response.errorBody().bytes();
        return MasterResponse.create(response.isSuccessful(), response.code(), response.body(), errorBody);
    }

    @AutoValue
    protected static abstract class MasterResponse<ResponseType> {
        protected MasterResponse() {
        }

        public abstract boolean isSuccess();

        public abstract int code();

        public abstract Optional<ResponseType> entity();

        public abstract Optional<byte[]> error();

        public Object body() {
            return this.entity().isPresent() ? this.entity().get() : this.error().orElse(null);
        }

        public static <ResponseType> MasterResponse<ResponseType> create(boolean isSuccess, int code, @Nullable ResponseType entity, @Nullable byte[] error) {
            return new AutoValue_ProxiedResource_MasterResponse<ResponseType>(isSuccess, code, Optional.ofNullable(entity), Optional.ofNullable(error));
        }
    }
}

