/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.conditions;

import java.util.Collections;
import java.util.Map;
import org.graylog.events.conditions.Expr;
import org.graylog.events.conditions.Expression;
import org.graylog.events.conditions.ExpressionVisitor;

public class BooleanNumberConditionsVisitor
implements ExpressionVisitor {
    private final Map<String, Double> numberReferences;

    public BooleanNumberConditionsVisitor() {
        this.numberReferences = Collections.emptyMap();
    }

    public BooleanNumberConditionsVisitor(Map<String, Double> numberReferences) {
        this.numberReferences = numberReferences;
    }

    private <T> T accept(Expression<T> expr) {
        return expr.accept(this);
    }

    @Override
    public boolean visit(Expr.True expr) {
        return true;
    }

    @Override
    public boolean visit(Expr.And and) {
        return this.accept(and.left()) != false && this.accept(and.right()) != false;
    }

    @Override
    public boolean visit(Expr.Or or) {
        return this.accept(or.left()) != false || this.accept(or.right()) != false;
    }

    @Override
    public boolean visit(Expr.Not not) {
        return this.accept(not.left()) == false;
    }

    @Override
    public boolean visit(Expr.Equal equal) {
        return this.accept(equal.left()).equals(this.accept(equal.right()));
    }

    @Override
    public boolean visit(Expr.Greater greater) {
        return this.accept(greater.left()) > this.accept(greater.right());
    }

    @Override
    public boolean visit(Expr.GreaterEqual greater) {
        return this.accept(greater.left()) >= this.accept(greater.right());
    }

    @Override
    public boolean visit(Expr.Lesser lesser) {
        return this.accept(lesser.left()) < this.accept(lesser.right());
    }

    @Override
    public boolean visit(Expr.LesserEqual lesser) {
        return this.accept(lesser.left()) <= this.accept(lesser.right());
    }

    @Override
    public double visit(Expr.NumberValue numberValue) {
        return numberValue.value();
    }

    @Override
    public double visit(Expr.NumberReference numberRef) {
        Double value = this.numberReferences.get(numberRef.ref());
        if (value == null) {
            throw new IllegalArgumentException("Couldn't find value for reference " + numberRef.toString());
        }
        return value;
    }
}

