/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.contentpack.facade;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.events.contentpack.entities.NotificationEntity;
import org.graylog.events.notifications.DBNotificationService;
import org.graylog.events.notifications.NotificationDto;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationFacade
implements EntityFacade<NotificationDto> {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationFacade.class);
    private final ObjectMapper objectMapper;
    private final DBNotificationService notificationService;

    @Inject
    public NotificationFacade(ObjectMapper objectMapper, DBNotificationService notificationService) {
        this.objectMapper = objectMapper;
        this.notificationService = notificationService;
    }

    @Override
    public Optional<Entity> exportEntity(EntityDescriptor entityDescriptor, EntityDescriptorIds entityDescriptorIds) {
        ModelId modelId = entityDescriptor.id();
        Optional notificationDto = this.notificationService.get(modelId.id());
        if (!notificationDto.isPresent()) {
            LOG.debug("Couldn't find notification {}", (Object)entityDescriptor);
            return Optional.empty();
        }
        NotificationEntity entity = (NotificationEntity)((NotificationDto)notificationDto.get()).toContentPackEntity(entityDescriptorIds);
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)entity, JsonNode.class);
        return Optional.of(((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(entityDescriptorIds.getOrThrow(((NotificationDto)notificationDto.get()).id(), ModelTypes.NOTIFICATION_V1)))).type(ModelTypes.NOTIFICATION_V1)).data(data).build());
    }

    @Override
    public NativeEntity<NotificationDto> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters, nativeEntities);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private NativeEntity<NotificationDto> decode(EntityV1 entityV1, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        NotificationEntity entity = (NotificationEntity)this.objectMapper.convertValue((Object)entityV1.data(), NotificationEntity.class);
        Object notificationDto = entity.toNativeEntity((Map)parameters, (Map)nativeEntities);
        NotificationDto savedDto = (NotificationDto)this.notificationService.save(notificationDto);
        return NativeEntity.create(entityV1.id(), savedDto.id(), ModelTypes.NOTIFICATION_V1, savedDto.title(), savedDto);
    }

    @Override
    public Optional<NativeEntity<NotificationDto>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        Optional notificationDto = this.notificationService.get(nativeEntityDescriptor.id().id());
        return notificationDto.map(notification -> NativeEntity.create(nativeEntityDescriptor, notification));
    }

    @Override
    public void delete(NotificationDto nativeEntity) {
        this.notificationService.delete(nativeEntity.id());
    }

    @Override
    public EntityExcerpt createExcerpt(NotificationDto nativeEntity) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(nativeEntity.id()))).type(ModelTypes.NOTIFICATION_V1)).title(nativeEntity.title()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.notificationService.streamAll().map(this::createExcerpt).collect(Collectors.toSet());
    }
}

