/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.events.processor.EventProcessorExecutionJob;
import org.graylog.scheduler.DBJobDefinitionService;
import org.graylog.scheduler.DBJobTriggerService;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDefinitionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(EventDefinitionHandler.class);
    private final DBEventDefinitionService eventDefinitionService;
    private final DBJobDefinitionService jobDefinitionService;
    private final DBJobTriggerService jobTriggerService;
    private final JobSchedulerClock clock;

    @Inject
    public EventDefinitionHandler(DBEventDefinitionService eventDefinitionService, DBJobDefinitionService jobDefinitionService, DBJobTriggerService jobTriggerService, JobSchedulerClock clock) {
        this.eventDefinitionService = eventDefinitionService;
        this.jobDefinitionService = jobDefinitionService;
        this.jobTriggerService = jobTriggerService;
        this.clock = clock;
    }

    public EventDefinitionDto create(EventDefinitionDto unsavedDto) {
        EventDefinitionDto dto = this.eventDefinitionService.save(unsavedDto);
        LOG.debug("Created event definition <{}/{}>", (Object)dto.id(), (Object)dto.title());
        try {
            dto.config().toJobSchedulerConfig(dto, this.clock).ifPresent(schedulerConfig -> {
                JobDefinitionDto unsavedJobDefinition = JobDefinitionDto.builder().title(dto.title()).description(dto.description()).config(schedulerConfig.jobDefinitionConfig()).build();
                JobDefinitionDto jobDefinition = this.jobDefinitionService.save(unsavedJobDefinition);
                LOG.debug("Created scheduler job definition <{}/{}> for event definition <{}/{}>", new Object[]{jobDefinition.id(), jobDefinition.title(), dto.id(), dto.title()});
                JobTriggerDto jobTrigger = JobTriggerDto.builderWithClock(this.clock).jobDefinitionId(Objects.requireNonNull(jobDefinition.id(), "Job definition ID cannot be null")).nextTime(this.clock.nowUTC()).schedule(schedulerConfig.schedule()).build();
                try {
                    JobTriggerDto savedTrigger = this.jobTriggerService.create(jobTrigger);
                    LOG.debug("Created job trigger <{}> for job definition <{}/{}> and event definition <{}/{}>", new Object[]{savedTrigger.id(), jobDefinition.id(), jobDefinition.title(), dto.id(), dto.title()});
                }
                catch (Exception e) {
                    LOG.error("Removing job definition <{}/{}> because of an error creating the job trigger", new Object[]{jobDefinition.id(), jobDefinition.title(), e});
                    this.jobDefinitionService.delete(jobDefinition.id());
                    throw e;
                }
            });
        }
        catch (Exception e) {
            LOG.error("Removing event definition <{}/{}> because of an error creating the job definition", new Object[]{dto.id(), dto.title(), e});
            this.eventDefinitionService.delete(dto.id());
            throw e;
        }
        return dto;
    }

    public EventDefinitionDto update(EventDefinitionDto updatedDto) {
        Optional oldDto = this.eventDefinitionService.get(updatedDto.id());
        EventDefinitionDto dto = this.eventDefinitionService.save(updatedDto);
        LOG.debug("Updated event definition <{}/{}>", (Object)dto.id(), (Object)dto.title());
        try {
            dto.config().toJobSchedulerConfig(dto, this.clock).ifPresent(schedulerConfig -> {
                JobDefinitionDto oldJobDefinition = this.jobDefinitionService.getByConfigField("event_definition_id", updatedDto.id()).orElseThrow(() -> new IllegalStateException("Couldn't find job definition for event definition <" + updatedDto.id() + ">"));
                JobDefinitionDto unsavedJobDefinition = oldJobDefinition.toBuilder().title(dto.title()).description(dto.description()).config(schedulerConfig.jobDefinitionConfig()).build();
                JobDefinitionDto jobDefinition = this.jobDefinitionService.save(unsavedJobDefinition);
                LOG.debug("Updated scheduler job definition <{}/{}> for event definition <{}/{}>", new Object[]{jobDefinition.id(), jobDefinition.title(), dto.id(), dto.title()});
                List<JobTriggerDto> jobTriggers = this.jobTriggerService.getForJob(jobDefinition.id());
                if (!jobTriggers.isEmpty()) {
                    JobTriggerDto jobTrigger = jobTriggers.get(0);
                    JobTriggerDto.Builder unsavedJobTriggerBuilder = jobTrigger.toBuilder().jobDefinitionId(Objects.requireNonNull(jobDefinition.id(), "Job definition ID cannot be null")).schedule(schedulerConfig.schedule()).nextTime(this.clock.nowUTC());
                    if (jobTrigger.data().isPresent()) {
                        EventProcessorExecutionJob.Config config = (EventProcessorExecutionJob.Config)jobDefinition.config();
                        EventProcessorExecutionJob.Data oldData = (EventProcessorExecutionJob.Data)jobTrigger.data().get();
                        EventProcessorExecutionJob.Data newData = EventProcessorExecutionJob.Data.builder().timerangeFrom(oldData.timerangeFrom()).timerangeTo(oldData.timerangeFrom().plus(config.processingWindowSize())).build();
                        unsavedJobTriggerBuilder.data(newData);
                        unsavedJobTriggerBuilder.nextTime(newData.timerangeTo());
                    }
                    JobTriggerDto unsavedJobTrigger = unsavedJobTriggerBuilder.build();
                    try {
                        this.jobTriggerService.update(unsavedJobTrigger);
                        LOG.debug("Updated scheduler job trigger <{}> for job definition <{}/{}> and event definition <{}/{}>", new Object[]{unsavedJobTrigger.id(), jobDefinition.id(), jobDefinition.title(), dto.id(), dto.title()});
                    }
                    catch (Exception e) {
                        LOG.error("Reverting to old job definition <{}/{}> because of an error updating the job trigger", new Object[]{jobDefinition.id(), jobDefinition.title(), e});
                        this.jobDefinitionService.save(oldJobDefinition);
                        throw e;
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error("Reverting to old event definition <{}/{}> because of an error updating the job definition", new Object[]{dto.id(), dto.title(), e});
            oldDto.ifPresent(this.eventDefinitionService::save);
            throw e;
        }
        return dto;
    }

    public boolean delete(String dtoId) {
        Optional dto = this.eventDefinitionService.get(dtoId);
        if (!dto.isPresent()) {
            return false;
        }
        this.jobDefinitionService.getByConfigField("event_definition_id", dtoId).ifPresent(jobDefinition -> {
            List<JobTriggerDto> jobTriggers = this.jobTriggerService.getForJob(jobDefinition.id());
            if (!jobTriggers.isEmpty()) {
                LOG.debug("Deleting scheduler job trigger <{}> for job definition <{}/{}> and event definition <{}/{}>", new Object[]{jobTriggers.get(0).id(), jobDefinition.id(), jobDefinition.title(), ((EventDefinitionDto)dto.get()).id(), ((EventDefinitionDto)dto.get()).title()});
                this.jobTriggerService.delete(jobTriggers.get(0).id());
            }
            LOG.debug("Deleting job definition <{}/{}> for event definition <{}/{}>", new Object[]{jobDefinition.id(), jobDefinition.title(), ((EventDefinitionDto)dto.get()).id(), ((EventDefinitionDto)dto.get()).title()});
            this.jobDefinitionService.delete(jobDefinition.id());
        });
        LOG.debug("Deleting event definition <{}/{}>", (Object)((EventDefinitionDto)dto.get()).id(), (Object)((EventDefinitionDto)dto.get()).title());
        return this.eventDefinitionService.delete(dtoId) > 0;
    }
}

