/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.MutableGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.events.contentpack.entities.AggregationEventProcessorConfigEntity;
import org.graylog.events.contentpack.entities.EventProcessorConfigEntity;
import org.graylog.events.processor.EventDefinition;
import org.graylog.events.processor.EventProcessorConfig;
import org.graylog.events.processor.EventProcessorExecutionJob;
import org.graylog.events.processor.EventProcessorSchedulerConfig;
import org.graylog.events.processor.aggregation.AggregationConditions;
import org.graylog.events.processor.aggregation.AggregationEventProcessorParameters;
import org.graylog.events.processor.aggregation.AggregationSeries;
import org.graylog.events.processor.aggregation.AutoValue_AggregationEventProcessorConfig;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog.scheduler.schedule.IntervalJobSchedule;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.rest.ValidationResult;
import org.joda.time.DateTime;

@JsonTypeName(value="aggregation-v1")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AggregationEventProcessorConfig
implements EventProcessorConfig {
    public static final String TYPE_NAME = "aggregation-v1";
    private static final String FIELD_QUERY = "query";
    private static final String FIELD_STREAMS = "streams";
    private static final String FIELD_GROUP_BY = "group_by";
    private static final String FIELD_SERIES = "series";
    private static final String FIELD_CONDITIONS = "conditions";
    private static final String FIELD_SEARCH_WITHIN_MS = "search_within_ms";
    private static final String FIELD_EXECUTE_EVERY_MS = "execute_every_ms";

    @JsonProperty(value="query")
    public abstract String query();

    @JsonProperty(value="streams")
    public abstract ImmutableSet<String> streams();

    @JsonProperty(value="group_by")
    public abstract List<String> groupBy();

    @JsonProperty(value="series")
    public abstract List<AggregationSeries> series();

    @JsonProperty(value="conditions")
    public abstract Optional<AggregationConditions> conditions();

    @JsonProperty(value="search_within_ms")
    public abstract long searchWithinMs();

    @JsonProperty(value="execute_every_ms")
    public abstract long executeEveryMs();

    @Override
    public Set<String> requiredPermissions() {
        if (this.streams().isEmpty()) {
            return Collections.singleton("streams:read");
        }
        return this.streams().stream().map(streamId -> String.join((CharSequence)":", "streams:read", streamId)).collect(Collectors.toSet());
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @Override
    public Optional<EventProcessorSchedulerConfig> toJobSchedulerConfig(EventDefinition eventDefinition, JobSchedulerClock clock) {
        DateTime now = clock.nowUTC();
        AbsoluteRange timerange = AbsoluteRange.create(now.minus(this.searchWithinMs()), now);
        EventProcessorExecutionJob.Config jobDefinitionConfig = EventProcessorExecutionJob.Config.builder().eventDefinitionId(eventDefinition.id()).processingWindowSize(this.searchWithinMs()).processingHopSize(this.executeEveryMs()).parameters(((AggregationEventProcessorParameters.Builder)AggregationEventProcessorParameters.builder().timerange(timerange)).build()).build();
        IntervalJobSchedule schedule = IntervalJobSchedule.builder().interval(this.executeEveryMs()).unit(TimeUnit.MILLISECONDS).build();
        return Optional.of(EventProcessorSchedulerConfig.create(jobDefinitionConfig, schedule));
    }

    private boolean isConditionsEmpty() {
        return !this.conditions().isPresent() || !this.conditions().get().expression().isPresent();
    }

    @Override
    public ValidationResult validate() {
        ValidationResult validationResult = new ValidationResult();
        if (this.searchWithinMs() <= 0L) {
            validationResult.addError(FIELD_SEARCH_WITHIN_MS, "Filter & Aggregation search_within_ms must be greater than 0.");
        }
        if (this.executeEveryMs() <= 0L) {
            validationResult.addError(FIELD_EXECUTE_EVERY_MS, "Filter & Aggregation execute_every_ms must be greater than 0.");
        }
        if (!this.groupBy().isEmpty() && (this.series().isEmpty() || this.isConditionsEmpty())) {
            validationResult.addError(FIELD_SERIES, "Aggregation with group_by must also contain series");
            validationResult.addError(FIELD_CONDITIONS, "Aggregation with group_by must also contain conditions");
        }
        if (this.series().isEmpty() && !this.isConditionsEmpty()) {
            validationResult.addError(FIELD_SERIES, "Aggregation with conditions must also contain series");
        }
        if (!this.series().isEmpty() && this.isConditionsEmpty()) {
            validationResult.addError(FIELD_CONDITIONS, "Aggregation with series must also contain conditions");
        }
        return validationResult;
    }

    @Override
    public EventProcessorConfigEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        ImmutableSet streamRefs = ImmutableSet.copyOf((Collection)this.streams().stream().map(streamId -> entityDescriptorIds.get((String)streamId, ModelTypes.STREAM_V1)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet()));
        return ((AggregationEventProcessorConfigEntity.Builder)AggregationEventProcessorConfigEntity.builder().type(this.type())).query(ValueReference.of(this.query())).streams((ImmutableSet<String>)streamRefs).groupBy(this.groupBy()).series(this.series()).conditions(this.conditions().orElse(null)).executeEveryMs(this.executeEveryMs()).searchWithinMs(this.searchWithinMs()).build();
    }

    @Override
    public void resolveNativeEntity(EntityDescriptor entityDescriptor, MutableGraph<EntityDescriptor> mutableGraph) {
        this.streams().forEach(streamId -> {
            EntityDescriptor depStream = ((EntityDescriptor.Builder)((EntityDescriptor.Builder)EntityDescriptor.builder().id(ModelId.of(streamId))).type(ModelTypes.STREAM_V1)).build();
            mutableGraph.putEdge((Object)entityDescriptor, (Object)depStream);
        });
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventProcessorConfig.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_AggregationEventProcessorConfig.Builder().type(AggregationEventProcessorConfig.TYPE_NAME);
        }

        @JsonProperty(value="query")
        public abstract Builder query(String var1);

        @JsonProperty(value="streams")
        public abstract Builder streams(Set<String> var1);

        @JsonProperty(value="group_by")
        public abstract Builder groupBy(List<String> var1);

        @JsonProperty(value="series")
        public abstract Builder series(List<AggregationSeries> var1);

        @JsonProperty(value="conditions")
        public abstract Builder conditions(@Nullable AggregationConditions var1);

        @JsonProperty(value="search_within_ms")
        public abstract Builder searchWithinMs(long var1);

        @JsonProperty(value="execute_every_ms")
        public abstract Builder executeEveryMs(long var1);

        public abstract AggregationEventProcessorConfig build();
    }
}

