/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.events.search.EventsSearchParameters;
import org.graylog.events.search.EventsSearchResult;
import org.graylog.events.search.EventsSearchService;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Events", description="Events overview and search")
@Path(value="/events")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RequiresAuthentication
public class EventsResource
extends RestResource
implements PluginRestResource {
    private final EventsSearchService searchService;

    @Inject
    public EventsResource(EventsSearchService searchService) {
        this.searchService = searchService;
    }

    @POST
    @Path(value="/search")
    @ApiOperation(value="Search events")
    @NoAuditEvent(value="Doesn't change any data, only searches for events")
    public EventsSearchResult search(EventsSearchParameters request) {
        return this.searchService.search(request, this.getSubject());
    }
}

