/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.migrations.AutoValue_V20190304102700_MigrateMessageListStructure_MigrationCompleted;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20190304102700_MigrateMessageListStructure
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20190304102700_MigrateMessageListStructure.class);
    private static final String LEGACY_MIGRATION_NAME = "org.graylog.plugins.enterprise.migrations.V20190304102700_MigrateMessageListStructure.MigrationCompleted";
    private final ClusterConfigService clusterConfigService;
    private final MongoCollection<Document> viewsCollections;
    private final MongoCollection<Document> searchCollections;

    @Inject
    public V20190304102700_MigrateMessageListStructure(MongoConnection mongoConnection, ClusterConfigService clusterConfigService) {
        this.viewsCollections = mongoConnection.getMongoDatabase().getCollection("views");
        this.searchCollections = mongoConnection.getMongoDatabase().getCollection("searches");
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2019-04-03T10:27:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null || this.clusterConfigService.get(LEGACY_MIGRATION_NAME, MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        ArrayList<String> viewIds = new ArrayList<String>();
        FindIterable documents = this.viewsCollections.find();
        for (Document view : documents) {
            String viewId;
            try {
                Document states = (Document)view.get((Object)"state", Document.class);
                states.forEach((id, obj) -> {
                    Document state = (Document)obj;
                    if (state.get((Object)"widgets") instanceof List) {
                        List widgets = (List)state.get((Object)"widgets");
                        for (Document widget : widgets) {
                            String type = widget.getString((Object)"type");
                            if (!type.equals("messages")) continue;
                            Document config = (Document)widget.get((Object)"config", Document.class);
                            List fields = (List)config.get((Object)"fields");
                            fields.add(0, "timestamp");
                            if (fields.contains("message")) {
                                config.put("show_message_row", (Object)true);
                                config.remove((Object)"message");
                            }
                            config.put("fields", (Object)fields);
                        }
                    }
                    this.createAllMessagesWidget(view, (String)id, state);
                });
                this.viewsCollections.updateOne((Bson)new BasicDBObject("_id", (Object)view.getObjectId((Object)"_id")), (Bson)new Document("$set", (Object)view));
                viewId = view.getObjectId((Object)"_id").toString();
                viewIds.add(viewId);
            }
            catch (Exception e) {
                viewId = view.getObjectId((Object)"_id").toString();
                LOG.error("Could not mirgarte view with ID {}", (Object)viewId);
            }
        }
        this.clusterConfigService.write(MigrationCompleted.create(viewIds));
    }

    private void createAllMessagesWidget(Document view, String stateId, Document state) {
        String widgetId = UUID.randomUUID().toString();
        List selectedFields = (List)state.get((Object)"selected_fields");
        selectedFields.add(0, "timestamp");
        boolean showMessageRow = selectedFields.contains("message");
        if (showMessageRow) {
            selectedFields.remove("message");
        }
        Document titles = (Document)state.get((Object)"titles", Document.class);
        Document widgetTitles = (Document)titles.get((Object)"widget", Document.class);
        widgetTitles.put(widgetId, (Object)"All Messages");
        List widgets = (List)state.get((Object)"widgets");
        Document newMessageList = this.createMessageList(widgetId, selectedFields, showMessageRow);
        widgets.add(newMessageList);
        Document positions = (Document)state.get((Object)"positions", Document.class);
        int newRow = this.findNewRow(positions);
        Document widgetPosition = this.createWidgetPosition(newRow);
        positions.put(widgetId, (Object)widgetPosition);
        Document widgetMappings = (Document)state.get((Object)"widget_mapping", Document.class);
        List<String> widgetMappingSearchTypeIds = this.getWidgetMappingSearchTypeIds(widgetMappings);
        String search_id = view.getString((Object)"search_id");
        List<String> searchTypeId = this.findSearchTypIds(stateId, search_id, widgetMappingSearchTypeIds);
        widgetMappings.put(widgetId, searchTypeId);
        state.put("static_message_list_id", (Object)widgetId);
    }

    private Document createMessageList(String widgetId, List<String> fields, boolean showMessageRow) {
        Document newMessageList = new Document();
        newMessageList.put("id", (Object)widgetId);
        newMessageList.put("type", (Object)"messages");
        Document widgetConfig = new Document();
        widgetConfig.put("fields", fields);
        widgetConfig.put("show_message_row", (Object)showMessageRow);
        newMessageList.put("config", (Object)widgetConfig);
        return newMessageList;
    }

    private int findNewRow(Document positions) {
        Optional<Integer> maxRow = positions.values().stream().map(pos -> ((Document)pos).getInteger((Object)"height") + ((Document)pos).getInteger((Object)"row")).max(Comparator.comparingInt(Integer::intValue));
        return maxRow.orElse(1);
    }

    private Document createWidgetPosition(int newRow) {
        Document widgetPosition = new Document();
        widgetPosition.put("col", (Object)1);
        widgetPosition.put("row", (Object)newRow);
        widgetPosition.put("width", (Object)Double.POSITIVE_INFINITY);
        widgetPosition.put("height", (Object)6);
        return widgetPosition;
    }

    private List<String> getWidgetMappingSearchTypeIds(Document widgetMappings) {
        ArrayList<String> widgetMappingSearchTypeIds = new ArrayList<String>();
        for (Map.Entry mapping : widgetMappings.entrySet()) {
            ArrayList searchIds = (ArrayList)mapping.getValue();
            widgetMappingSearchTypeIds.addAll(searchIds);
        }
        return widgetMappingSearchTypeIds;
    }

    private List<String> findSearchTypIds(String stateId, String searchId, List<String> widgetMappingSearchTypeIds) {
        BasicDBObject dbQuery = new BasicDBObject();
        dbQuery.put((Object)"_id", (Object)new ObjectId(searchId));
        FindIterable searches = this.searchCollections.find((Bson)dbQuery);
        assert (this.searchCollections.count((Bson)dbQuery) == 1L);
        Document search = (Document)searches.first();
        ArrayList<String> searchTypeId = new ArrayList<String>();
        ArrayList queries = (ArrayList)search.get((Object)"queries");
        for (Document query : queries) {
            if (!query.getString((Object)"id").equals(stateId)) continue;
            ArrayList searchTypes = (ArrayList)query.get((Object)"search_types");
            searchTypeId.addAll(searchTypes.stream().map(searchType -> searchType.getString((Object)"id")).filter(search_id -> !widgetMappingSearchTypeIds.contains(search_id)).collect(Collectors.toList()));
        }
        return searchTypeId;
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="viewIds")
        public abstract List<String> viewIds();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="viewIds") List<String> viewIds) {
            return new AutoValue_V20190304102700_MigrateMessageListStructure_MigrationCompleted(viewIds);
        }
    }
}

