/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Parameter;

final class AutoValue_Parameter
extends Parameter {
    private final String name;
    private final String title;
    private final String description;
    private final String dataType;
    private final Object defaultValue;
    private final boolean optional;
    private final Parameter.Binding binding;

    private AutoValue_Parameter(String name, @Nullable String title, @Nullable String description, String dataType, @Nullable Object defaultValue, boolean optional, @Nullable Parameter.Binding binding) {
        this.name = name;
        this.title = title;
        this.description = description;
        this.dataType = dataType;
        this.defaultValue = defaultValue;
        this.optional = optional;
        this.binding = binding;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    @JsonProperty
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    @JsonProperty
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="data_type")
    public String dataType() {
        return this.dataType;
    }

    @Override
    @Nullable
    @JsonProperty(value="default_value")
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    @JsonProperty
    public boolean optional() {
        return this.optional;
    }

    @Override
    @Nullable
    @JsonProperty
    public Parameter.Binding binding() {
        return this.binding;
    }

    public String toString() {
        return "Parameter{name=" + this.name + ", title=" + this.title + ", description=" + this.description + ", dataType=" + this.dataType + ", defaultValue=" + this.defaultValue + ", optional=" + this.optional + ", binding=" + this.binding + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Parameter) {
            Parameter that = (Parameter)o;
            return this.name.equals(that.name()) && (this.title == null ? that.title() == null : this.title.equals(that.title())) && (this.description == null ? that.description() == null : this.description.equals(that.description())) && this.dataType.equals(that.dataType()) && (this.defaultValue == null ? that.defaultValue() == null : this.defaultValue.equals(that.defaultValue())) && this.optional == that.optional() && (this.binding == null ? that.binding() == null : this.binding.equals(that.binding()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.title == null ? 0 : this.title.hashCode();
        h$ *= 1000003;
        h$ ^= this.description == null ? 0 : this.description.hashCode();
        h$ *= 1000003;
        h$ ^= this.dataType.hashCode();
        h$ *= 1000003;
        h$ ^= this.defaultValue == null ? 0 : this.defaultValue.hashCode();
        h$ *= 1000003;
        h$ ^= this.optional ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.binding == null ? 0 : this.binding.hashCode();
    }

    @Override
    public Parameter.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Parameter.Builder {
        private String name;
        private String title;
        private String description;
        private String dataType;
        private Object defaultValue;
        private Boolean optional;
        private Parameter.Binding binding;

        Builder() {
        }

        private Builder(Parameter source) {
            this.name = source.name();
            this.title = source.title();
            this.description = source.description();
            this.dataType = source.dataType();
            this.defaultValue = source.defaultValue();
            this.optional = source.optional();
            this.binding = source.binding();
        }

        @Override
        public Parameter.Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public Parameter.Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public Parameter.Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Parameter.Builder dataType(String dataType) {
            if (dataType == null) {
                throw new NullPointerException("Null dataType");
            }
            this.dataType = dataType;
            return this;
        }

        @Override
        public Parameter.Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public Parameter.Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        @Override
        public Parameter.Builder binding(Parameter.Binding binding) {
            this.binding = binding;
            return this;
        }

        @Override
        public Parameter build() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.dataType == null) {
                missing = missing + " dataType";
            }
            if (this.optional == null) {
                missing = missing + " optional";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Parameter(this.name, this.title, this.description, this.dataType, this.defaultValue, this.optional, this.binding);
        }
    }
}

