/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

final class AutoValue_Query
extends Query {
    private final String id;
    private final TimeRange timerange;
    private final Filter filter;
    private final BackendQuery query;
    private final ImmutableSet<SearchType> searchTypes;

    private AutoValue_Query(String id, TimeRange timerange, @Nullable Filter filter, BackendQuery query, ImmutableSet<SearchType> searchTypes) {
        this.id = id;
        this.timerange = timerange;
        this.filter = filter;
        this.query = query;
        this.searchTypes = searchTypes;
    }

    @Override
    @JsonProperty
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public TimeRange timerange() {
        return this.timerange;
    }

    @Override
    @Nullable
    @JsonProperty
    public Filter filter() {
        return this.filter;
    }

    @Override
    @Nonnull
    @JsonProperty
    public BackendQuery query() {
        return this.query;
    }

    @Override
    @Nonnull
    @JsonProperty(value="search_types")
    public ImmutableSet<SearchType> searchTypes() {
        return this.searchTypes;
    }

    public String toString() {
        return "Query{id=" + this.id + ", timerange=" + this.timerange + ", filter=" + this.filter + ", query=" + this.query + ", searchTypes=" + this.searchTypes + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Query) {
            Query that = (Query)o;
            return this.id.equals(that.id()) && this.timerange.equals(that.timerange()) && (this.filter == null ? that.filter() == null : this.filter.equals(that.filter())) && this.query.equals(that.query()) && this.searchTypes.equals(that.searchTypes());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.timerange.hashCode();
        h$ *= 1000003;
        h$ ^= this.filter == null ? 0 : this.filter.hashCode();
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        return h$ ^= this.searchTypes.hashCode();
    }

    @Override
    public Query.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Query.Builder {
        private String id;
        private TimeRange timerange;
        private Filter filter;
        private BackendQuery query;
        private ImmutableSet<SearchType> searchTypes;

        Builder() {
        }

        private Builder(Query source) {
            this.id = source.id();
            this.timerange = source.timerange();
            this.filter = source.filter();
            this.query = source.query();
            this.searchTypes = source.searchTypes();
        }

        @Override
        public Query.Builder id(String id) {
            if (id == null) {
                throw new NullPointerException("Null id");
            }
            this.id = id;
            return this;
        }

        @Override
        public Query.Builder timerange(TimeRange timerange) {
            if (timerange == null) {
                throw new NullPointerException("Null timerange");
            }
            this.timerange = timerange;
            return this;
        }

        @Override
        public Query.Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public Query.Builder query(BackendQuery query) {
            if (query == null) {
                throw new NullPointerException("Null query");
            }
            this.query = query;
            return this;
        }

        @Override
        public Query.Builder searchTypes(@Nullable Set<SearchType> searchTypes) {
            this.searchTypes = ImmutableSet.copyOf(searchTypes);
            return this;
        }

        @Override
        Query autoBuild() {
            String missing = "";
            if (this.id == null) {
                missing = missing + " id";
            }
            if (this.timerange == null) {
                missing = missing + " timerange";
            }
            if (this.query == null) {
                missing = missing + " query";
            }
            if (this.searchTypes == null) {
                missing = missing + " searchTypes";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Query(this.id, this.timerange, this.filter, this.query, this.searchTypes);
        }
    }
}

