/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

final class AutoValue_Search
extends Search {
    private final String id;
    private final ImmutableSet<Query> queries;
    private final ImmutableSet<Parameter> parameters;
    private final Map<String, PluginMetadataSummary> requires;
    private final Optional<String> owner;
    private final DateTime createdAt;

    private AutoValue_Search(@Nullable String id, ImmutableSet<Query> queries, ImmutableSet<Parameter> parameters, Map<String, PluginMetadataSummary> requires, Optional<String> owner, DateTime createdAt) {
        this.id = id;
        this.queries = queries;
        this.parameters = parameters;
        this.requires = requires;
        this.owner = owner;
        this.createdAt = createdAt;
    }

    @Override
    @Id
    @ObjectId
    @Nullable
    @JsonProperty
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public ImmutableSet<Query> queries() {
        return this.queries;
    }

    @Override
    @JsonProperty
    public ImmutableSet<Parameter> parameters() {
        return this.parameters;
    }

    @Override
    @JsonProperty(value="requires")
    public Map<String, PluginMetadataSummary> requires() {
        return this.requires;
    }

    @Override
    @JsonProperty(value="owner")
    public Optional<String> owner() {
        return this.owner;
    }

    @Override
    @JsonProperty(value="created_at")
    public DateTime createdAt() {
        return this.createdAt;
    }

    public String toString() {
        return "Search{id=" + this.id + ", queries=" + this.queries + ", parameters=" + this.parameters + ", requires=" + this.requires + ", owner=" + this.owner + ", createdAt=" + this.createdAt + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Search) {
            Search that = (Search)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.queries.equals(that.queries()) && this.parameters.equals(that.parameters()) && this.requires.equals(that.requires()) && this.owner.equals(that.owner()) && this.createdAt.equals((Object)that.createdAt());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.queries.hashCode();
        h$ *= 1000003;
        h$ ^= this.parameters.hashCode();
        h$ *= 1000003;
        h$ ^= this.requires.hashCode();
        h$ *= 1000003;
        h$ ^= this.owner.hashCode();
        h$ *= 1000003;
        return h$ ^= this.createdAt.hashCode();
    }

    @Override
    public Search.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Search.Builder {
        private String id;
        private ImmutableSet<Query> queries;
        private ImmutableSet<Parameter> parameters;
        private Map<String, PluginMetadataSummary> requires;
        private Optional<String> owner = Optional.empty();
        private DateTime createdAt;

        Builder() {
        }

        private Builder(Search source) {
            this.id = source.id();
            this.queries = source.queries();
            this.parameters = source.parameters();
            this.requires = source.requires();
            this.owner = source.owner();
            this.createdAt = source.createdAt();
        }

        @Override
        public Search.Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Search.Builder queries(ImmutableSet<Query> queries) {
            if (queries == null) {
                throw new NullPointerException("Null queries");
            }
            this.queries = queries;
            return this;
        }

        @Override
        public Search.Builder parameters(ImmutableSet<Parameter> parameters) {
            if (parameters == null) {
                throw new NullPointerException("Null parameters");
            }
            this.parameters = parameters;
            return this;
        }

        @Override
        public Search.Builder requires(Map<String, PluginMetadataSummary> requires) {
            if (requires == null) {
                throw new NullPointerException("Null requires");
            }
            this.requires = requires;
            return this;
        }

        @Override
        public Search.Builder owner(String owner) {
            this.owner = Optional.of(owner);
            return this;
        }

        @Override
        public Search.Builder createdAt(DateTime createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("Null createdAt");
            }
            this.createdAt = createdAt;
            return this;
        }

        @Override
        Search autoBuild() {
            String missing = "";
            if (this.queries == null) {
                missing = missing + " queries";
            }
            if (this.parameters == null) {
                missing = missing + " parameters";
            }
            if (this.requires == null) {
                missing = missing + " requires";
            }
            if (this.createdAt == null) {
                missing = missing + " createdAt";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Search(this.id, this.queries, this.parameters, this.requires, this.owner, this.createdAt);
        }
    }
}

