/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.AutoValue_Parameter;
import org.graylog.plugins.views.search.QueryResult;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Parameter {
    @JsonProperty
    public abstract String name();

    @Nullable
    @JsonProperty
    public abstract String title();

    @Nullable
    @JsonProperty
    public abstract String description();

    @JsonProperty(value="data_type")
    public abstract String dataType();

    @Nullable
    @JsonProperty(value="default_value")
    public abstract Object defaultValue();

    @JsonProperty
    public abstract boolean optional();

    @Nullable
    @JsonProperty
    public abstract Binding binding();

    public static Builder builder() {
        return new AutoValue_Parameter.Builder().optional(false);
    }

    public static Parameter any(String name) {
        return Parameter.builder().name(name).dataType("any").build();
    }

    public abstract Builder toBuilder();

    public Parameter applyExecutionState(ObjectMapper objectMapper, JsonNode state) {
        JsonNode bindingState = state.path(this.name());
        if (bindingState.isMissingNode()) {
            return this;
        }
        Binding binding = (Binding)objectMapper.convertValue((Object)bindingState, Binding.class);
        return this.toBuilder().binding(binding).build();
    }

    public static interface BindingHandler<B extends Binding> {
        default public Object resolve(Binding binding, Object defaultValue, Map<String, QueryResult> results) {
            return this.doResolve(binding, defaultValue, results);
        }

        public Object doResolve(B var1, Object var2, Map<String, QueryResult> var3);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder name(String var1);

        @JsonProperty
        public abstract Builder title(String var1);

        @JsonProperty
        public abstract Builder description(String var1);

        @JsonProperty
        public abstract Builder dataType(String var1);

        @JsonProperty(value="default_value")
        public abstract Builder defaultValue(Object var1);

        @JsonProperty
        public abstract Builder optional(boolean var1);

        @JsonProperty
        public abstract Builder binding(Binding var1);

        public abstract Parameter build();

        @JsonCreator
        public static Builder create() {
            return Parameter.builder().optional(false);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true, defaultImpl=Fallback.class)
    public static interface Binding {
        public static final String TYPE_FIELD = "type";

        @JsonProperty(value="type")
        public String type();

        public static class Fallback
        implements Binding {
            @JsonProperty
            private String type;
            private Map<String, Object> props = Maps.newHashMap();

            @Override
            public String type() {
                return this.type;
            }

            @JsonAnySetter
            public void setProperties(String key, Object value) {
                this.props.put(key, value);
            }

            @JsonAnyGetter
            public Map<String, Object> getProperties() {
                return this.props;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Fallback fallback = (Fallback)o;
                return Objects.equals(this.type, fallback.type) && Objects.equals(this.props, fallback.props);
            }

            public int hashCode() {
                return Objects.hash(this.type, this.props);
            }
        }
    }
}

