/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.graph.Traverser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.AutoValue_Query;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.engine.EmptyTimeRange;
import org.graylog.plugins.views.search.filter.StreamFilter;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Query {
    private static final Logger LOG = LoggerFactory.getLogger(Query.class);
    @JsonIgnore
    private ImmutableMap<String, SearchType> searchTypesIndex;

    @JsonProperty
    public abstract String id();

    @JsonProperty
    public abstract TimeRange timerange();

    @Nullable
    @JsonProperty
    public abstract Filter filter();

    @Nonnull
    @JsonProperty
    public abstract BackendQuery query();

    @Nonnull
    @JsonProperty(value="search_types")
    public abstract ImmutableSet<SearchType> searchTypes();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_Query.Builder().searchTypes((Set<SearchType>)ImmutableSortedSet.of());
    }

    public Query applyExecutionState(ObjectMapper objectMapper, JsonNode state) {
        if (state.isMissingNode()) {
            return this;
        }
        boolean hasTimerange = state.hasNonNull("timerange");
        boolean hasSearchTypes = state.hasNonNull("search_types");
        if (hasTimerange || hasSearchTypes) {
            Builder builder = this.toBuilder();
            if (hasTimerange) {
                try {
                    JsonNode rawTimerange = state.path("timerange");
                    TimeRange newTimeRange = (TimeRange)objectMapper.convertValue((Object)rawTimerange, TimeRange.class);
                    builder.timerange(newTimeRange);
                }
                catch (Exception e) {
                    LOG.error("Unable to deserialize execution state for time range", (Throwable)e);
                }
            }
            if (hasSearchTypes) {
                HashMap updatedSearchTypes = Maps.newHashMap(this.searchTypesIndex);
                state.path("search_types").fields().forEachRemaining(stateEntry -> {
                    String id = (String)stateEntry.getKey();
                    SearchType searchType = (SearchType)this.searchTypesIndex.get((Object)id);
                    SearchType updatedSearchType = searchType.applyExecutionContext(objectMapper, (JsonNode)stateEntry.getValue());
                    updatedSearchTypes.put(id, updatedSearchType);
                });
                builder.searchTypes((Set<SearchType>)ImmutableSet.copyOf(updatedSearchTypes.values()));
            }
            return builder.build();
        }
        return this;
    }

    public static Query emptyRoot() {
        return Query.builder().id("").timerange(EmptyTimeRange.emptyTimeRange()).query(new BackendQuery.Fallback()).filter(null).build();
    }

    public Set<String> usedStreamIds() {
        if (this.filter() != null) {
            Traverser filterTraverser = Traverser.forTree(filter -> (Set)MoreObjects.firstNonNull(filter.filters(), Collections.emptySet()));
            return StreamSupport.stream(filterTraverser.breadthFirst((Object)this.filter()).spliterator(), false).filter(filter -> filter instanceof StreamFilter).map(streamFilter -> ((StreamFilter)streamFilter).streamId()).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @JsonPOJOBuilder(withPrefix="")
    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder id(String var1);

        @JsonProperty
        public abstract Builder timerange(TimeRange var1);

        @JsonProperty
        public abstract Builder filter(Filter var1);

        @JsonProperty
        public abstract Builder query(BackendQuery var1);

        @JsonProperty(value="search_types")
        public abstract Builder searchTypes(@Nullable Set<SearchType> var1);

        abstract Query autoBuild();

        @JsonCreator
        public static Builder createWithDefaults() {
            return Query.builder();
        }

        public Query build() {
            Query query = this.autoBuild();
            query.searchTypesIndex = Maps.uniqueIndex(query.searchTypes(), SearchType::id);
            return query;
        }
    }
}

