/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.AutoValue_Search;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Search {
    public static final String FIELD_REQUIRES = "requires";
    private static final String FIELD_CREATED_AT = "created_at";
    public static final String FIELD_OWNER = "owner";
    private ImmutableMap<String, Query> queryIndex;
    private ImmutableMap<String, Parameter> parameterIndex;

    @Id
    @ObjectId
    @Nullable
    @JsonProperty
    public abstract String id();

    @JsonProperty
    public abstract ImmutableSet<Query> queries();

    @JsonProperty
    public abstract ImmutableSet<Parameter> parameters();

    @JsonProperty(value="requires")
    public abstract Map<String, PluginMetadataSummary> requires();

    @JsonProperty(value="owner")
    public abstract Optional<String> owner();

    @JsonProperty(value="created_at")
    public abstract DateTime createdAt();

    public Search applyExecutionState(ObjectMapper objectMapper, Map<String, Object> executionState) {
        Builder builder = this.toBuilder();
        JsonNode state = (JsonNode)objectMapper.convertValue(executionState, JsonNode.class);
        if (state.hasNonNull("parameter_bindings")) {
            ImmutableSet parameters = (ImmutableSet)this.parameters().stream().map(param -> param.applyExecutionState(objectMapper, state.path("parameter_bindings"))).collect(ImmutableSet.toImmutableSet());
            builder.parameters((ImmutableSet<Parameter>)parameters);
        }
        if (state.hasNonNull("queries")) {
            ImmutableSet queries = (ImmutableSet)this.queries().stream().map(query -> query.applyExecutionState(objectMapper, state.path("queries").path(query.id()))).collect(ImmutableSet.toImmutableSet());
            builder.queries((ImmutableSet<Query>)queries);
        }
        return builder.build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return Builder.create().parameters((ImmutableSet<Parameter>)ImmutableSet.of()).queries((ImmutableSet<Query>)ImmutableSet.builder().build());
    }

    @JsonIgnore
    public Optional<Query> getQuery(String sourceQueryId) {
        return Optional.ofNullable((Query)this.queryIndex.get((Object)sourceQueryId));
    }

    @JsonIgnore
    public Optional<Parameter> getParameter(String parameterName) {
        return Optional.ofNullable((Parameter)this.parameterIndex.get((Object)parameterName));
    }

    @JsonPOJOBuilder(withPrefix="")
    @AutoValue.Builder
    public static abstract class Builder {
        @Id
        @JsonProperty
        public abstract Builder id(String var1);

        @JsonProperty
        public abstract Builder queries(ImmutableSet<Query> var1);

        @JsonProperty
        public abstract Builder parameters(ImmutableSet<Parameter> var1);

        @JsonProperty(value="requires")
        public abstract Builder requires(Map<String, PluginMetadataSummary> var1);

        @JsonProperty(value="owner")
        public abstract Builder owner(String var1);

        @JsonProperty(value="created_at")
        public abstract Builder createdAt(DateTime var1);

        abstract Search autoBuild();

        @JsonCreator
        public static Builder create() {
            return new AutoValue_Search.Builder().requires(Collections.emptyMap()).createdAt(DateTime.now((DateTimeZone)DateTimeZone.UTC)).parameters((ImmutableSet<Parameter>)ImmutableSet.of());
        }

        public Search build() {
            Search search = this.autoBuild();
            search.queryIndex = Maps.uniqueIndex(search.queries(), Query::id);
            search.parameterIndex = Maps.uniqueIndex(search.parameters(), Parameter::name);
            return search;
        }
    }
}

