/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=Fallback.class)
@JsonAutoDetect
public interface SearchType {
    public static final String TYPE_FIELD = "type";

    @JsonProperty(value="type")
    public String type();

    @JsonProperty(value="id")
    public String id();

    @Nullable
    @JsonProperty(value="filter")
    public Filter filter();

    public SearchType applyExecutionContext(ObjectMapper var1, JsonNode var2);

    @JsonAutoDetect
    public static class Fallback
    implements SearchType {
        @JsonProperty
        private String type;
        @JsonProperty
        private String id;
        private Map<String, Object> props = Maps.newHashMap();
        @Nullable
        @JsonProperty
        private Filter filter;

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Filter filter() {
            return this.filter;
        }

        @Override
        public SearchType applyExecutionContext(ObjectMapper objectMapper, JsonNode state) {
            return this;
        }

        @JsonAnySetter
        public void setProperties(String key, Object value) {
            this.props.put(key, value);
        }

        @JsonAnyGetter
        public Map<String, Object> getProperties() {
            return this.props;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Fallback fallback = (Fallback)o;
            return Objects.equals(this.type, fallback.type) && Objects.equals(this.id, fallback.id) && Objects.equals(this.props, fallback.props);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.id, this.props);
        }
    }

    public static interface Result {
        @JsonProperty(value="id")
        public String id();

        @JsonProperty(value="type")
        public String type();
    }
}

