/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.db;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Streams;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchRequirements;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog.plugins.views.search.views.ViewService;
import org.graylog.plugins.views.search.views.sharing.IsViewSharedForUser;
import org.graylog.plugins.views.search.views.sharing.ViewSharing;
import org.graylog.plugins.views.search.views.sharing.ViewSharingService;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.database.users.User;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class SearchDbService {
    protected final JacksonDBCollection<Search, ObjectId> db;
    private final ViewService viewService;
    private final ViewSharingService viewSharingService;
    private final IsViewSharedForUser isViewSharedForUser;
    private final SearchRequirements.Factory searchRequirementsFactory;

    @Inject
    protected SearchDbService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ViewService viewService, ViewSharingService viewSharingService, IsViewSharedForUser isViewSharedForUser, SearchRequirements.Factory searchRequirementsFactory) {
        this.viewService = viewService;
        this.viewSharingService = viewSharingService;
        this.isViewSharedForUser = isViewSharedForUser;
        this.searchRequirementsFactory = searchRequirementsFactory;
        this.db = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection("searches"), Search.class, ObjectId.class, (ObjectMapper)mapper.get());
        this.db.createIndex((DBObject)new BasicDBObject("created_at", (Object)1), (DBObject)new BasicDBObject("unique", (Object)false));
    }

    public Optional<Search> get(String id) {
        return Optional.ofNullable((Search)this.db.findOneById((Object)new ObjectId(id))).map(this::requirementsForSearch);
    }

    public Optional<Search> getForUser(String id, User user, Predicate<String> permissionChecker) {
        Optional<Search> search = this.get(id).map(this::requirementsForSearch);
        if (!search.isPresent()) {
            return Optional.empty();
        }
        if (search.map(s -> s.owner().map(owner -> owner.equals(user.getName())).orElse(false)).orElse(false).booleanValue()) {
            return search;
        }
        if (this.viewService.forSearch(id).stream().map(view -> this.viewSharingService.forView(view.id())).anyMatch(viewSharing -> viewSharing.map(sharing -> this.isViewSharedForUser.isAllowedToSee(user, (ViewSharing)sharing)).orElse(false))) {
            return search;
        }
        if (this.viewService.forSearch(id).stream().anyMatch(view -> permissionChecker.test(view.id()))) {
            return search;
        }
        return Optional.empty();
    }

    public Search save(Search search) {
        Search searchToSave = this.requirementsForSearch(search);
        if (searchToSave.id() != null) {
            this.db.update(DBQuery.is((String)"_id", (Object)search.id()), (Object)searchToSave, true, false);
            return searchToSave;
        }
        WriteResult save = this.db.insert((Object)searchToSave);
        return (Search)save.getSavedObject();
    }

    public PaginatedList<Search> findPaginated(DBQuery.Query search, DBSort.SortBuilder sort, int page, int perPage) {
        DBCursor cursor = this.db.find(search).sort((DBObject)sort).limit(perPage).skip(perPage * Math.max(0, page - 1));
        return new PaginatedList<Search>(Streams.stream((Iterable)cursor).map(this::requirementsForSearch).collect(Collectors.toList()), cursor.count(), page, perPage);
    }

    public void delete(String id) {
        this.db.removeById((Object)new ObjectId(id));
    }

    public Collection<Search> findByIds(Set<String> idSet) {
        return Streams.stream((Iterable)this.db.find(DBQuery.in((String)"_id", (Collection)idSet.stream().map(ObjectId::new).collect(Collectors.toList())))).map(this::requirementsForSearch).collect(Collectors.toList());
    }

    public Stream<Search> streamAll() {
        return Streams.stream((Iterable)this.db.find()).map(this::requirementsForSearch);
    }

    private Search requirementsForSearch(Search search) {
        return this.searchRequirementsFactory.create(search).rebuildRequirements(Search::requires, (s, newRequirements) -> s.toBuilder().requires((Map<String, PluginMetadataSummary>)newRequirements).build());
    }
}

