/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch.searchtypes;

import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.Bucket;
import io.searchbox.core.search.aggregation.DateHistogramAggregation;
import io.searchbox.core.search.aggregation.MetricAggregation;
import java.util.Collection;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ESGeneratedQueryContext;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.ESSearchTypeHandler;
import org.graylog.plugins.views.search.searchtypes.DateHistogram;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;

public class ESDateHistogram
implements ESSearchTypeHandler<DateHistogram> {
    @Override
    public void doGenerateQueryPart(SearchJob job, Query query, DateHistogram dateHistogram, ESGeneratedQueryContext queryContext) {
        DateHistogramAggregationBuilder builder = ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)dateHistogram.id()).field("timestamp")).dateHistogramInterval(dateHistogram.interval().toESInterval());
        queryContext.addAggregation((AggregationBuilder)builder, dateHistogram);
    }

    @Override
    public SearchType.Result doExtractResult(SearchJob job, Query query, DateHistogram searchType, SearchResult result, MetricAggregation aggregations, ESGeneratedQueryContext queryContext) {
        DateHistogramAggregation dateHistogramAggregation = aggregations.getDateHistogramAggregation(searchType.id());
        Map buckets = StreamEx.of((Collection)dateHistogramAggregation.getBuckets()).mapToEntry(bucket -> new DateTime((Object)bucket.getKey()).getMillis() / 1000L, Bucket::getCount).toMap();
        TimeRange timerange = query.timerange();
        return DateHistogram.Result.result(searchType.id()).results(buckets).timerange(AbsoluteRange.create(timerange.getFrom(), timerange.getTo())).build();
    }
}

