/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch.searchtypes;

import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.MetricAggregation;
import java.util.Locale;
import javax.annotation.Nullable;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ESGeneratedQueryContext;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.ESSearchTypeHandler;
import org.graylog.plugins.views.search.searchtypes.FieldMetric;

public class ESFieldMetric
implements ESSearchTypeHandler<FieldMetric> {
    @Override
    public void doGenerateQueryPart(SearchJob job, Query query, FieldMetric fieldMetric, ESGeneratedQueryContext queryContext) {
        SearchSourceBuilder queryBuilder = queryContext.searchSourceBuilder(fieldMetric);
        switch (fieldMetric.operation()) {
            case AVG: {
                queryBuilder.aggregation((AggregationBuilder)AggregationBuilders.avg((String)this.aggName(fieldMetric)).field(fieldMetric.field()));
                break;
            }
            case CARDINALITY: {
                queryBuilder.aggregation((AggregationBuilder)AggregationBuilders.cardinality((String)this.aggName(fieldMetric)).field(fieldMetric.field()));
                break;
            }
            case COUNT: {
                queryBuilder.aggregation((AggregationBuilder)AggregationBuilders.count((String)this.aggName(fieldMetric)).field(fieldMetric.field()));
                break;
            }
            case MAX: {
                queryBuilder.aggregation((AggregationBuilder)AggregationBuilders.max((String)this.aggName(fieldMetric)).field(fieldMetric.field()));
                break;
            }
            case MIN: {
                queryBuilder.aggregation((AggregationBuilder)AggregationBuilders.min((String)this.aggName(fieldMetric)).field(fieldMetric.field()));
                break;
            }
            case SUM: {
                queryBuilder.aggregation((AggregationBuilder)AggregationBuilders.sum((String)this.aggName(fieldMetric)).field(fieldMetric.field()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation: " + fieldMetric.operation().toString());
            }
        }
    }

    @Override
    public SearchType.Result doExtractResult(SearchJob job, Query query, FieldMetric fieldMetric, SearchResult queryResult, MetricAggregation aggregations, ESGeneratedQueryContext queryContext) {
        SearchType.Result result;
        String id = fieldMetric.id();
        switch (fieldMetric.operation()) {
            case AVG: {
                result = this.doubleResult(id, aggregations.getAvgAggregation(this.aggName(fieldMetric)).getAvg());
                break;
            }
            case CARDINALITY: {
                result = this.longResult(id, aggregations.getCardinalityAggregation(this.aggName(fieldMetric)).getCardinality());
                break;
            }
            case COUNT: {
                result = this.longResult(id, aggregations.getValueCountAggregation(this.aggName(fieldMetric)).getValueCount());
                break;
            }
            case MAX: {
                result = this.doubleResult(id, aggregations.getMaxAggregation(this.aggName(fieldMetric)).getMax());
                break;
            }
            case MIN: {
                result = this.doubleResult(id, aggregations.getMinAggregation(this.aggName(fieldMetric)).getMin());
                break;
            }
            case SUM: {
                result = this.doubleResult(id, aggregations.getSumAggregation(this.aggName(fieldMetric)).getSum());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation: " + fieldMetric.operation().toString());
            }
        }
        return result;
    }

    private SearchType.Result doubleResult(String id, @Nullable Double value) {
        if (value == null) {
            return FieldMetric.DoubleResult.builder().id(id).value(0.0).build();
        }
        return FieldMetric.DoubleResult.builder().id(id).value(value).build();
    }

    private SearchType.Result longResult(String id, @Nullable Long value) {
        if (value == null) {
            return FieldMetric.LongResult.builder().id(id).value(0L).build();
        }
        return FieldMetric.LongResult.builder().id(id).value(value).build();
    }

    private String aggName(FieldMetric fieldMetric) {
        return String.format(Locale.ENGLISH, "field-metric-%s", fieldMetric.id());
    }
}

