/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch.searchtypes;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.MetricAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ESGeneratedQueryContext;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.ESSearchTypeHandler;
import org.graylog.plugins.views.search.searchtypes.GroupBy;

public class ESGroupBy
implements ESSearchTypeHandler<GroupBy> {
    private static final String STACKED_TERMS_AGG_SEPARATOR = "\u2e31";

    AbstractAggregationBuilder createTermsBuilder(String field, List<String> stackedFields, GroupBy groupBy) {
        int size = Ints.saturatedCast((long)groupBy.limit());
        Terms.Order termsOrder = Terms.Order.count((groupBy.order() == SortOrder.ASC ? 1 : 0) != 0);
        if (stackedFields.isEmpty()) {
            return AggregationBuilders.filter((String)this.filterAggName(groupBy), (QueryBuilder)QueryBuilders.matchAllQuery()).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)this.termsAggName(groupBy)).field(field)).size(size).order(termsOrder));
        }
        StringBuilder scriptStringBuilder = new StringBuilder();
        BoolQueryBuilder filterQuery = QueryBuilders.boolQuery();
        scriptStringBuilder.append("doc['").append(field).append("'].value");
        filterQuery.must((QueryBuilder)QueryBuilders.existsQuery((String)field));
        stackedFields.forEach(f -> {
            scriptStringBuilder.append(" + \"").append(STACKED_TERMS_AGG_SEPARATOR).append("\" + ");
            scriptStringBuilder.append("doc['").append((String)f).append("'].value");
            filterQuery.must((QueryBuilder)QueryBuilders.existsQuery((String)f));
        });
        return AggregationBuilders.filter((String)this.filterAggName(groupBy), (QueryBuilder)filterQuery).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)this.termsAggName(groupBy)).script(new Script(ScriptType.INLINE, "painless", scriptStringBuilder.toString(), Collections.emptyMap()))).size(size).order(termsOrder));
    }

    @Override
    public void doGenerateQueryPart(SearchJob job, Query query, GroupBy groupBy, ESGeneratedQueryContext queryContext) {
        String mainField = groupBy.fields().get(0);
        List<String> stackedFields = groupBy.fields().subList(1, groupBy.fields().size());
        queryContext.searchSourceBuilder(groupBy).aggregation((AggregationBuilder)this.createTermsBuilder(mainField, stackedFields, groupBy));
    }

    @Override
    public SearchType.Result doExtractResult(SearchJob job, Query query, GroupBy groupBy, SearchResult queryResult, MetricAggregation aggregations, ESGeneratedQueryContext queryContext) {
        TermsAggregation termsAggregation = aggregations.getFilterAggregation(this.filterAggName(groupBy)).getTermsAggregation(this.termsAggName(groupBy));
        return this.extractTermsAggregationResult(groupBy, termsAggregation);
    }

    GroupBy.Result extractTermsAggregationResult(GroupBy groupBy, TermsAggregation termsAggregation) {
        ImmutableList.Builder groups = ImmutableList.builder();
        for (TermsAggregation.Entry entry : termsAggregation.getBuckets()) {
            List valueList = Splitter.on((String)STACKED_TERMS_AGG_SEPARATOR).splitToList((CharSequence)entry.getKey());
            ImmutableList.Builder fields = ImmutableList.builder();
            for (int i = 0; i < groupBy.fields().size(); ++i) {
                fields.add((Object)GroupBy.GroupField.builder().field(groupBy.fields().get(i)).value((String)valueList.get(i)).build());
            }
            groups.add((Object)GroupBy.Group.builder().count(entry.getCount()).fields((List<GroupBy.GroupField>)fields.build()).build());
        }
        return GroupBy.Result.builder().id(groupBy.id()).groups((List<GroupBy.Group>)groups.build()).build();
    }

    String filterAggName(GroupBy groupBy) {
        return String.format(Locale.ENGLISH, "group-by-filter-%s", groupBy.id());
    }

    String termsAggName(GroupBy groupBy) {
        return String.format(Locale.ENGLISH, "group-by-terms-%s", groupBy.id());
    }
}

