/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch.searchtypes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.DateHistogramAggregation;
import io.searchbox.core.search.aggregation.MetricAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ESGeneratedQueryContext;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.ESGroupBy;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.ESSearchTypeHandler;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.IntervalHelper;
import org.graylog.plugins.views.search.searchtypes.GroupBy;
import org.graylog.plugins.views.search.searchtypes.GroupByHistogram;
import org.graylog2.indexer.searches.Searches;
import org.joda.time.DateTime;

public class ESGroupByHistogram
implements ESSearchTypeHandler<GroupByHistogram> {
    private GroupBy createGroupBy(GroupByHistogram groupByHistogram) {
        return GroupBy.builder().id(groupByHistogram.id()).fields(groupByHistogram.fields()).limit(groupByHistogram.limit()).operation(groupByHistogram.operation()).order(groupByHistogram.order()).build();
    }

    @Override
    public void doGenerateQueryPart(SearchJob job, Query query, GroupByHistogram groupByHistogram, ESGeneratedQueryContext queryContext) {
        String mainField = groupByHistogram.fields().get(0);
        List<String> stackedFields = groupByHistogram.fields().subList(1, groupByHistogram.fields().size());
        Searches.DateHistogramInterval interval = (Searches.DateHistogramInterval)((Object)MoreObjects.firstNonNull((Object)((Object)groupByHistogram.interval()), (Object)((Object)IntervalHelper.createDefaultInterval(query.timerange()))));
        GroupBy groupBy = this.createGroupBy(groupByHistogram);
        ESGroupBy esGroupBy = new ESGroupBy();
        DateHistogramAggregationBuilder histogram = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)this.histogramAggName(groupByHistogram)).field("timestamp")).dateHistogramInterval(interval.toESInterval()).subAggregation((AggregationBuilder)esGroupBy.createTermsBuilder(mainField, stackedFields, groupBy));
        queryContext.searchSourceBuilder(groupByHistogram).aggregation((AggregationBuilder)histogram);
    }

    @Override
    public SearchType.Result doExtractResult(SearchJob job, Query query, GroupByHistogram groupByHistogram, SearchResult queryResult, MetricAggregation aggregations, ESGeneratedQueryContext queryContext) {
        DateHistogramAggregation aggregation = aggregations.getDateHistogramAggregation(this.histogramAggName(groupByHistogram));
        GroupBy groupBy = this.createGroupBy(groupByHistogram);
        ESGroupBy esGroupBy = new ESGroupBy();
        ImmutableMap.Builder buckets = ImmutableMap.builder();
        for (DateHistogramAggregation.DateHistogram dateHistogram : aggregation.getBuckets()) {
            DateTime keyAsDate = new DateTime((Object)dateHistogram.getKey());
            TermsAggregation termsAggregation = dateHistogram.getFilterAggregation(esGroupBy.filterAggName(groupBy)).getTermsAggregation(esGroupBy.termsAggName(groupBy));
            GroupBy.Result groupByResult = esGroupBy.extractTermsAggregationResult(groupBy, termsAggregation);
            buckets.put((Object)keyAsDate.getMillis(), (Object)GroupByHistogram.Bucket.builder().groups(groupByResult.groups()).build());
        }
        return GroupByHistogram.Result.builder().id(groupByHistogram.id()).buckets((Map<Long, GroupByHistogram.Bucket>)buckets.build()).build();
    }

    private String histogramAggName(GroupByHistogram groupByHistogram) {
        return String.format(Locale.ENGLISH, "group-by-histogram-%s", groupByHistogram.id());
    }
}

