/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch.searchtypes;

import com.google.common.base.MoreObjects;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.MetricAggregation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ESGeneratedQueryContext;
import org.graylog.plugins.views.search.elasticsearch.ESQueryDecorators;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.ESSearchTypeHandler;
import org.graylog.plugins.views.search.searchtypes.MessageList;
import org.graylog.plugins.views.search.searchtypes.Sort;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;

public class ESMessageList
implements ESSearchTypeHandler<MessageList> {
    private final ESQueryDecorators esQueryDecorators;

    @Inject
    public ESMessageList(ESQueryDecorators esQueryDecorators) {
        this.esQueryDecorators = esQueryDecorators;
    }

    @Override
    public void doGenerateQueryPart(SearchJob job, Query query, MessageList messageList, ESGeneratedQueryContext queryContext) {
        String queryString = this.esQueryDecorators.decorate(((ElasticsearchQueryString)query.query()).queryString(), job, query, Collections.emptySet());
        SearchSourceBuilder searchSourceBuilder = queryContext.searchSourceBuilder(messageList).size(messageList.limit() - messageList.offset()).from(messageList.offset()).highlighter((HighlightBuilder)((HighlightBuilder)((HighlightBuilder)((HighlightBuilder)new HighlightBuilder().requireFieldMatch(Boolean.valueOf(false))).highlightQuery((QueryBuilder)QueryBuilders.queryStringQuery((String)queryString))).field("*").fragmentSize(Integer.valueOf(0))).numOfFragments(Integer.valueOf(0)));
        List sorts = (List)MoreObjects.firstNonNull(messageList.sort(), Collections.singletonList(Sort.create("timestamp", SortOrder.DESC)));
        sorts.forEach(sort -> searchSourceBuilder.sort(sort.field(), sort.order()));
    }

    @Override
    public SearchType.Result doExtractResult(SearchJob job, Query query, MessageList searchType, SearchResult result, MetricAggregation aggregations, ESGeneratedQueryContext queryContext) {
        List<ResultMessageSummary> messages = result.getHits(Map.class, false).stream().map(hit -> ResultMessage.parseFromSource(hit.id, hit.index, (Map)hit.source, hit.highlight)).map(resultMessage -> ResultMessageSummary.create(resultMessage.highlightRanges, resultMessage.getMessage().getFields(), resultMessage.getIndex())).collect(Collectors.toList());
        return MessageList.Result.result(searchType.id()).messages(messages).totalResults(result.getTotal()).build();
    }
}

