/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch.searchtypes.pivot;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.Aggregation;
import io.searchbox.core.search.aggregation.MetricAggregation;
import java.util.ArrayDeque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.max.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.min.MinAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ESGeneratedQueryContext;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.ESSearchTypeHandler;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.pivot.ESPivotBucketSpecHandler;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.pivot.ESPivotSeriesSpecHandler;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotResult;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESPivot
implements ESSearchTypeHandler<Pivot> {
    private static final Logger LOG = LoggerFactory.getLogger(ESPivot.class);
    private final Map<String, ESPivotBucketSpecHandler<? extends BucketSpec, ? extends Aggregation>> bucketHandlers;
    private final Map<String, ESPivotSeriesSpecHandler<? extends SeriesSpec, ? extends Aggregation>> seriesHandlers;

    @Inject
    public ESPivot(Map<String, ESPivotBucketSpecHandler<? extends BucketSpec, ? extends Aggregation>> bucketHandlers, Map<String, ESPivotSeriesSpecHandler<? extends SeriesSpec, ? extends Aggregation>> seriesHandlers) {
        this.bucketHandlers = bucketHandlers;
        this.seriesHandlers = seriesHandlers;
    }

    @Override
    public void doGenerateQueryPart(SearchJob job, Query query, Pivot pivot, ESGeneratedQueryContext queryContext) {
        LOG.debug("Generating aggregation for {}", (Object)pivot);
        SearchSourceBuilder searchSourceBuilder = queryContext.searchSourceBuilder(pivot);
        Map<Object, Object> contextMap = queryContext.contextMap();
        AggTypes aggTypes = new AggTypes();
        contextMap.put(pivot.id(), aggTypes);
        AggregationBuilder topLevelAggregation = null;
        AggregationBuilder previousAggregation = null;
        if (pivot.rollup()) {
            this.seriesStream(pivot, queryContext, "global rollup").forEach(previousAggregation != null ? arg_0 -> previousAggregation.subAggregation(arg_0) : arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).aggregation(arg_0));
        }
        Iterator<BucketSpec> rowBuckets = pivot.rowGroups().iterator();
        while (rowBuckets.hasNext()) {
            BucketSpec bucketSpec = rowBuckets.next();
            String name = queryContext.nextName();
            LOG.debug("Creating row group aggregation '{}' as {}", (Object)bucketSpec.type(), (Object)name);
            ESPivotBucketSpecHandler<? extends BucketSpec, ? extends Aggregation> handler = this.bucketHandlers.get(bucketSpec.type());
            if (handler == null) {
                throw new IllegalArgumentException("Unknown row_group type " + bucketSpec.type());
            }
            Optional generatedAggregation = handler.createAggregation(name, pivot, bucketSpec, this, queryContext, query);
            if (!generatedAggregation.isPresent()) continue;
            AggregationBuilder aggregationBuilder = (AggregationBuilder)generatedAggregation.get();
            if (topLevelAggregation == null) {
                topLevelAggregation = aggregationBuilder;
            }
            if (!rowBuckets.hasNext() || pivot.rollup()) {
                this.seriesStream(pivot, queryContext, !rowBuckets.hasNext() ? "leaf row" : "row rollup").forEach(arg_0 -> ((AggregationBuilder)aggregationBuilder).subAggregation(arg_0));
            }
            if (previousAggregation != null) {
                previousAggregation.subAggregation(aggregationBuilder);
            } else {
                searchSourceBuilder.aggregation(aggregationBuilder);
            }
            previousAggregation = aggregationBuilder;
        }
        Iterator<BucketSpec> colBuckets = pivot.columnGroups().iterator();
        while (colBuckets.hasNext()) {
            BucketSpec bucketSpec = colBuckets.next();
            String name = queryContext.nextName();
            LOG.debug("Creating column group aggregation '{}' as {}", (Object)bucketSpec.type(), (Object)name);
            ESPivotBucketSpecHandler<? extends BucketSpec, ? extends Aggregation> handler = this.bucketHandlers.get(bucketSpec.type());
            if (handler == null) {
                throw new IllegalArgumentException("Unknown column_group type " + bucketSpec.type());
            }
            Optional generatedAggregation = handler.createAggregation(name, pivot, bucketSpec, this, queryContext, query);
            if (!generatedAggregation.isPresent()) continue;
            AggregationBuilder aggregationBuilder = (AggregationBuilder)generatedAggregation.get();
            if (!colBuckets.hasNext() || pivot.rollup()) {
                this.seriesStream(pivot, queryContext, !colBuckets.hasNext() ? "leaf column" : "column rollup").forEach(arg_0 -> ((AggregationBuilder)aggregationBuilder).subAggregation(arg_0));
            }
            if (previousAggregation != null) {
                previousAggregation.subAggregation(aggregationBuilder);
            } else {
                searchSourceBuilder.aggregation(aggregationBuilder);
            }
            previousAggregation = aggregationBuilder;
        }
        MinAggregationBuilder startTimestamp = (MinAggregationBuilder)AggregationBuilders.min((String)"timestamp-min").field("timestamp");
        MaxAggregationBuilder endTimestamp = (MaxAggregationBuilder)AggregationBuilders.max((String)"timestamp-max").field("timestamp");
        searchSourceBuilder.aggregation((AggregationBuilder)startTimestamp);
        searchSourceBuilder.aggregation((AggregationBuilder)endTimestamp);
        if (topLevelAggregation == null) {
            LOG.debug("No aggregations generated for {}", (Object)pivot);
        }
    }

    private Stream<AggregationBuilder> seriesStream(Pivot pivot, ESGeneratedQueryContext queryContext, String reason) {
        return ((StreamEx)EntryStream.of(pivot.series()).mapKeyValue((integer, seriesSpec) -> {
            String seriesName = queryContext.seriesName((SeriesSpec)seriesSpec, pivot);
            LOG.debug("Adding {} series '{}' with name '{}'", new Object[]{reason, seriesSpec.type(), seriesName});
            ESPivotSeriesSpecHandler<? extends SeriesSpec, ? extends Aggregation> esPivotSeriesSpecHandler = this.seriesHandlers.get(seriesSpec.type());
            if (esPivotSeriesSpecHandler == null) {
                throw new IllegalArgumentException("No series handler registered for: " + seriesSpec.type());
            }
            return esPivotSeriesSpecHandler.createAggregation(seriesName, pivot, (SeriesSpec)seriesSpec, this, queryContext);
        }).filter(Optional::isPresent)).map(Optional::get);
    }

    @Override
    public SearchType.Result doExtractResult(SearchJob job, Query query, Pivot pivot, SearchResult queryResult, MetricAggregation aggregations, ESGeneratedQueryContext queryContext) {
        Double from = queryResult.getAggregations().getMinAggregation("timestamp-min").getMin();
        Double to = queryResult.getAggregations().getMaxAggregation("timestamp-max").getMax();
        AbsoluteRange effectiveTimerange = AbsoluteRange.create(from == null ? query.timerange().getFrom() : new DateTime(from.longValue(), DateTimeZone.UTC), to == null ? query.timerange().getTo() : new DateTime(to.longValue(), DateTimeZone.UTC));
        PivotResult.Builder resultBuilder = PivotResult.builder().id(pivot.id()).effectiveTimerange(effectiveTimerange).total(this.extractDocumentCount(queryResult, pivot, queryContext));
        this.processRows(resultBuilder, queryResult, queryContext, pivot, pivot.rowGroups(), new ArrayDeque<String>(), aggregations);
        return resultBuilder.build();
    }

    private long extractDocumentCount(SearchResult queryResult, Pivot pivot, ESGeneratedQueryContext queryContext) {
        return queryResult.getTotal();
    }

    private void processRows(PivotResult.Builder resultBuilder, SearchResult searchResult, ESGeneratedQueryContext queryContext, Pivot pivot, List<BucketSpec> remainingRows, ArrayDeque<String> rowKeys, MetricAggregation aggregation) {
        if (remainingRows.isEmpty()) {
            PivotResult.Row.Builder rowBuilder = PivotResult.Row.builder().key((ImmutableList<String>)ImmutableList.copyOf(rowKeys));
            this.processColumns(rowBuilder, searchResult, queryContext, pivot, pivot.columnGroups(), new ArrayDeque<String>(), aggregation);
            if (pivot.rollup()) {
                this.processSeries(rowBuilder, searchResult, queryContext, pivot, new ArrayDeque<String>(), aggregation, true, "row-leaf");
            }
            resultBuilder.addRow(rowBuilder.source("leaf").build());
        } else {
            BucketSpec currentBucket = remainingRows.get(0);
            ESPivotBucketSpecHandler<? extends BucketSpec, ? extends Aggregation> handler = this.bucketHandlers.get(currentBucket.type());
            Aggregation aggregationResult = handler.extractAggregationFromResult(pivot, currentBucket, aggregation, queryContext);
            Object bucketStream = handler.handleResult(pivot, currentBucket, searchResult, aggregationResult, this, queryContext);
            bucketStream.forEach(bucket -> {
                rowKeys.addLast(bucket.key());
                this.processRows(resultBuilder, searchResult, queryContext, pivot, ESPivot.tail(remainingRows), rowKeys, bucket.aggregation());
                rowKeys.removeLast();
            });
            if (pivot.rollup()) {
                PivotResult.Row.Builder rowBuilder = PivotResult.Row.builder().key((ImmutableList<String>)ImmutableList.copyOf(rowKeys));
                this.processSeries(rowBuilder, searchResult, queryContext, pivot, new ArrayDeque<String>(), aggregation, true, "row-inner");
                resultBuilder.addRow(rowBuilder.source("non-leaf").build());
            }
        }
    }

    private void processColumns(PivotResult.Row.Builder rowBuilder, SearchResult searchResult, ESGeneratedQueryContext queryContext, Pivot pivot, List<BucketSpec> remainingColumns, ArrayDeque<String> columnKeys, MetricAggregation aggregation) {
        if (remainingColumns.isEmpty()) {
            if (!columnKeys.isEmpty()) {
                this.processSeries(rowBuilder, searchResult, queryContext, pivot, columnKeys, aggregation, false, "col-leaf");
            }
        } else {
            BucketSpec currentBucket = remainingColumns.get(0);
            ESPivotBucketSpecHandler<? extends BucketSpec, ? extends Aggregation> handler = this.bucketHandlers.get(currentBucket.type());
            Aggregation aggregationResult = handler.extractAggregationFromResult(pivot, currentBucket, aggregation, queryContext);
            Object bucketStream = handler.handleResult(pivot, currentBucket, searchResult, aggregationResult, this, queryContext);
            bucketStream.forEach(bucket -> {
                columnKeys.addLast(bucket.key());
                this.processColumns(rowBuilder, searchResult, queryContext, pivot, ESPivot.tail(remainingColumns), columnKeys, bucket.aggregation());
                columnKeys.removeLast();
            });
            if (pivot.rollup() && !columnKeys.isEmpty()) {
                this.processSeries(rowBuilder, searchResult, queryContext, pivot, columnKeys, aggregation, true, "col-inner");
            }
        }
    }

    private void processSeries(PivotResult.Row.Builder rowBuilder, SearchResult searchResult, ESGeneratedQueryContext queryContext, Pivot pivot, ArrayDeque<String> columnKeys, MetricAggregation aggregation, boolean rollup, String source) {
        pivot.series().forEach(seriesSpec -> {
            ESPivotSeriesSpecHandler<? extends SeriesSpec, ? extends Aggregation> seriesHandler = this.seriesHandlers.get(seriesSpec.type());
            Aggregation series = seriesHandler.extractAggregationFromResult(pivot, (PivotSpec)seriesSpec, aggregation, queryContext);
            seriesHandler.handleResult(pivot, (SeriesSpec)seriesSpec, searchResult, series, this, queryContext).map(value -> {
                columnKeys.addLast(value.id());
                PivotResult.Value v = PivotResult.Value.create(columnKeys, value.value(), rollup, source);
                columnKeys.removeLast();
                return v;
            }).forEach(rowBuilder::addValue);
        });
    }

    private static <T> List<T> tail(List<T> list) {
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"List must not be empty!");
        return list.subList(1, list.size());
    }

    public static class AggTypes {
        final IdentityHashMap<PivotSpec, Tuple2<String, Class<? extends Aggregation>>> aggTypeMap = new IdentityHashMap();

        public void record(PivotSpec pivotSpec, String name, Class<? extends Aggregation> aggClass) {
            this.aggTypeMap.put(pivotSpec, (Tuple2<String, Class<? extends Aggregation>>)Tuple.tuple((Object)name, aggClass));
        }

        public Aggregation getSubAggregation(PivotSpec pivotSpec, MetricAggregation currentAggregationOrBucket) {
            Tuple2<String, Class<? extends Aggregation>> tuple2 = this.getTypes(pivotSpec);
            return currentAggregationOrBucket.getAggregation((String)tuple2.v1, (Class)tuple2.v2);
        }

        public Tuple2<String, Class<? extends Aggregation>> getTypes(PivotSpec pivotSpec) {
            return this.aggTypeMap.get(pivotSpec);
        }
    }
}

