/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryMetadata;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.engine.GeneratedQueryContext;
import org.graylog.plugins.views.search.engine.QueryExecutionStats;
import org.graylog.plugins.views.search.errors.QueryError;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotResult;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public interface QueryBackend<T extends GeneratedQueryContext> {
    public T generate(SearchJob var1, Query var2, Set<QueryResult> var3);

    default public boolean isAllMessages(TimeRange timeRange) {
        return timeRange instanceof RelativeRange && ((RelativeRange)timeRange).range() == 0;
    }

    default public AbsoluteRange effectiveTimeRangeForResult(Query query, QueryResult queryResult) {
        Optional<AbsoluteRange> effectiveRange;
        if (this.isAllMessages(query.timerange()) && (effectiveRange = queryResult.searchTypes().values().stream().filter(result -> result instanceof PivotResult).map(result -> ((PivotResult)result).effectiveTimerange()).reduce((prev, next) -> {
            DateTime from = prev.from().compareTo((ReadableInstant)next.from()) < 0 ? prev.from() : next.from();
            DateTime to = prev.to().compareTo((ReadableInstant)next.to()) < 0 ? next.to() : prev.to();
            return AbsoluteRange.create(from, to);
        })).isPresent()) {
            return effectiveRange.get();
        }
        return AbsoluteRange.create(query.timerange().getFrom(), query.timerange().getTo());
    }

    default public QueryResult run(SearchJob job, Query query, GeneratedQueryContext generatedQueryContext, Set<QueryResult> predecessorResults) {
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            QueryExecutionStats.Builder statsBuilder = QueryExecutionStats.builderWithCurrentTime();
            QueryResult result = this.doRun(job, query, generatedQueryContext, predecessorResults);
            stopwatch.stop();
            return result.toBuilder().executionStats(statsBuilder.duration(stopwatch.elapsed(TimeUnit.MILLISECONDS)).effectiveTimeRange(this.effectiveTimeRangeForResult(query, result)).build()).build();
        }
        catch (Exception e) {
            QueryError queryError = new QueryError(query, e);
            generatedQueryContext.addError(queryError);
            return QueryResult.failedQueryWithError(query, queryError);
        }
    }

    public QueryResult doRun(SearchJob var1, Query var2, T var3, Set<QueryResult> var4);

    public QueryMetadata parse(ImmutableSet<Parameter> var1, Query var2);
}

