/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.rest.FieldTypesForStreamsRequest;
import org.graylog.plugins.views.search.rest.MappedFieldTypeDTO;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.fieldtypes.FieldTypeDTO;
import org.graylog2.indexer.fieldtypes.FieldTypeMapper;
import org.graylog2.indexer.fieldtypes.FieldTypes;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesService;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;

@Api(value="Enterprise/Field Types", description="Field Types")
@Path(value="/views/fields")
@Produces(value={"application/json"})
@RequiresAuthentication
public class FieldTypesResource
extends RestResource
implements PluginRestResource {
    private final IndexFieldTypesService indexFieldTypesService;
    private final StreamService streamService;
    private final FieldTypeMapper fieldTypeMapper;
    private static final FieldTypes.Type UNKNOWN_TYPE = FieldTypes.Type.createType("unknown", (Set<String>)ImmutableSet.of());
    private static final String PROP_COMPOUND_TYPE = "compound";

    @Inject
    public FieldTypesResource(IndexFieldTypesService indexFieldTypesService, StreamService streamService, FieldTypeMapper fieldTypeMapper) {
        this.indexFieldTypesService = indexFieldTypesService;
        this.streamService = streamService;
        this.fieldTypeMapper = fieldTypeMapper;
    }

    private Set<MappedFieldTypeDTO> mergeCompoundFieldTypes(Stream<MappedFieldTypeDTO> stream) {
        return stream.collect(Collectors.groupingBy(MappedFieldTypeDTO::name, Collectors.toSet())).entrySet().stream().map(entry -> {
            Set fieldTypes = (Set)entry.getValue();
            String fieldName = (String)entry.getKey();
            if (fieldTypes.size() == 1) {
                return (MappedFieldTypeDTO)fieldTypes.iterator().next();
            }
            String compoundFieldType = "compound(" + fieldTypes.stream().map(mappedFieldTypeDTO -> mappedFieldTypeDTO.type().type()).collect(Collectors.joining(",")) + ")";
            ImmutableSet commonProperties = fieldTypes.stream().map(mappedFieldTypeDTO -> mappedFieldTypeDTO.type().properties()).reduce((s1, s2) -> Sets.intersection((Set)s1, (Set)s2).immutableCopy()).orElse(ImmutableSet.of());
            ImmutableSet properties = ImmutableSet.builder().addAll((Iterable)commonProperties).add((Object)PROP_COMPOUND_TYPE).build();
            return MappedFieldTypeDTO.create(fieldName, FieldTypes.Type.createType(compoundFieldType, (Set<String>)properties));
        }).collect(Collectors.toSet());
    }

    private MappedFieldTypeDTO mapPhysicalFieldType(FieldTypeDTO fieldType) {
        FieldTypes.Type mappedFieldType = this.fieldTypeMapper.mapType(fieldType.physicalType()).orElse(UNKNOWN_TYPE);
        return MappedFieldTypeDTO.create(fieldType.fieldName(), mappedFieldType);
    }

    @GET
    @ApiOperation(value="Retrieve the list of all fields present in the system")
    public Set<MappedFieldTypeDTO> allFieldTypes() {
        if (this.allowedToReadStream("*")) {
            return this.mergeCompoundFieldTypes(this.indexFieldTypesService.findAll().stream().map(IndexFieldTypesDTO::fields).flatMap(Collection::stream).map(this::mapPhysicalFieldType));
        }
        Set<String> allowedStreams = this.streamService.loadAll().stream().map(Persisted::getId).filter(this::allowedToReadStream).collect(Collectors.toSet());
        return this.fieldTypesByStreamIds(allowedStreams);
    }

    private boolean allowedToReadStream(String streamId) {
        return this.isPermitted("streams:read", streamId);
    }

    @POST
    @ApiOperation(value="Retrieve the field list of a given set of streams")
    @NoAuditEvent(value="This is not changing any data")
    public Set<MappedFieldTypeDTO> byStreams(FieldTypesForStreamsRequest request) {
        request.streams().forEach(s -> this.checkPermission("streams:read", (String)s));
        return this.fieldTypesByStreamIds(request.streams());
    }

    private Set<MappedFieldTypeDTO> fieldTypesByStreamIds(Set<String> streamIds) {
        return this.mergeCompoundFieldTypes(streamIds.stream().map(streamId -> {
            try {
                return this.streamService.load((String)streamId);
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
        }).filter(Objects::nonNull).map(indexSet -> indexSet.getIndexSet().getConfig().id()).flatMap(indexSetId -> this.indexFieldTypesService.findForIndexSet((String)indexSetId).stream()).map(IndexFieldTypesDTO::fields).flatMap(Collection::stream).map(this::mapPhysicalFieldType));
    }
}

