/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.views.search.views.QualifyingViewsService;
import org.graylog.plugins.views.search.views.ViewParameterSummaryDTO;
import org.graylog.plugins.views.search.views.sharing.IsViewSharedForUser;
import org.graylog.plugins.views.search.views.sharing.ViewSharing;
import org.graylog.plugins.views.search.views.sharing.ViewSharingService;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Enterprise/Views/QualifyingViews", description="List qualifying views for view interlinking")
@Path(value="/views/forValue")
@Produces(value={"application/json"})
@RequiresAuthentication
@RequiresPermissions(value={"view:use"})
public class QualifyingViewsResource
extends RestResource
implements PluginRestResource {
    private final QualifyingViewsService qualifyingViewsService;
    private final ViewSharingService viewSharingService;
    private final IsViewSharedForUser isViewSharedForUser;

    @Inject
    public QualifyingViewsResource(QualifyingViewsService qualifyingViewsService, ViewSharingService viewSharingService, IsViewSharedForUser isViewSharedForUser) {
        this.qualifyingViewsService = qualifyingViewsService;
        this.viewSharingService = viewSharingService;
        this.isViewSharedForUser = isViewSharedForUser;
    }

    @POST
    @ApiOperation(value="Get all views that match given parameter value")
    @NoAuditEvent(value="Only returning matching views, not changing any data")
    public Collection<ViewParameterSummaryDTO> forParameter() {
        return this.qualifyingViewsService.forValue().stream().filter(view -> {
            Optional<ViewSharing> viewSharing = this.viewSharingService.forView(view.id());
            return this.isPermitted("view:read", view.id()) || viewSharing.map(sharing -> this.isViewSharedForUser.isAllowedToSee(this.getCurrentUser(), (ViewSharing)sharing)).orElse(false) != false;
        }).collect(Collectors.toSet());
    }
}

