/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import one.util.streamex.StreamEx;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchMetadata;
import org.graylog.plugins.views.search.db.SearchDbService;
import org.graylog.plugins.views.search.db.SearchJobService;
import org.graylog.plugins.views.search.engine.QueryEngine;
import org.graylog.plugins.views.search.filter.AndFilter;
import org.graylog.plugins.views.search.filter.OrFilter;
import org.graylog.plugins.views.search.filter.StreamFilter;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Enterprise/Search", description="Searching")
@Path(value="/views/search")
@Produces(value={"application/json"})
@RequiresAuthentication
@RequiresPermissions(value={"extendedsearch:use"})
public class SearchResource
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResource.class);
    private static final String BASE_PATH = "views/search";
    private final QueryEngine queryEngine;
    private final SearchDbService searchDbService;
    private final SearchJobService searchJobService;
    private final ObjectMapper objectMapper;
    private final StreamService streamService;
    private final Map<String, PluginMetaData> providedCapabilities;

    @Inject
    public SearchResource(QueryEngine queryEngine, SearchDbService searchDbService, SearchJobService searchJobService, ObjectMapper objectMapper, StreamService streamService, Map<String, PluginMetaData> providedCapabilities) {
        this.queryEngine = queryEngine;
        this.searchDbService = searchDbService;
        this.searchJobService = searchJobService;
        this.objectMapper = objectMapper;
        this.streamService = streamService;
        this.providedCapabilities = providedCapabilities;
    }

    @VisibleForTesting
    boolean isOwnerOfSearch(Search search, String username) {
        return search.owner().map(owner -> owner.equals(username)).orElse(true);
    }

    @POST
    @ApiOperation(value="Create a search query", response=Search.class, code=201)
    @RequiresPermissions(value={"extendedsearch:create"})
    @AuditEvent(type="views:search:create")
    public Response createSearch(@ApiParam Search search) {
        String username = this.getCurrentUser() != null ? this.getCurrentUser().getName() : null;
        boolean isAdmin = this.getCurrentUser() != null && (this.getCurrentUser().isLocalAdmin() || this.isPermitted("*"));
        Optional<Search> previous = this.searchDbService.get(search.id());
        if (!isAdmin && !previous.map(existingSearch -> this.isOwnerOfSearch((Search)existingSearch, username)).orElse(true).booleanValue()) {
            throw new ForbiddenException("Unable to update search with id <" + search.id() + ">, already exists and user is not permitted to overwrite it.");
        }
        Search saved = this.searchDbService.save(search.toBuilder().owner(username).build());
        if (saved == null || saved.id() == null) {
            return Response.serverError().build();
        }
        LOG.debug("Created new search object {}", (Object)saved.id());
        return Response.created((URI)URI.create(Objects.requireNonNull(saved.id()))).entity((Object)saved).build();
    }

    @GET
    @ApiOperation(value="Retrieve a search query")
    @Path(value="{id}")
    public Search getSearch(@ApiParam(name="id") @PathParam(value="id") String searchId) {
        return this.searchDbService.getForUser(searchId, this.getCurrentUser(), viewId -> this.isPermitted("view:read", (String)viewId)).orElseThrow(() -> new NotFoundException("No such search " + searchId));
    }

    @GET
    @ApiOperation(value="Get all current search queries in the system")
    public List<Search> getAllSearches() {
        try (Stream<Search> searchStream = this.searchDbService.streamAll();){
            List<Search> list = searchStream.collect(Collectors.toList());
            return list;
        }
    }

    private void checkUserIsPermittedToSeeStreams(Set<String> streamIds) {
        Set forbiddenStreams = streamIds.stream().filter(streamId -> !this.isPermitted("streams:read", (String)streamId)).collect(Collectors.toSet());
        if (!forbiddenStreams.isEmpty()) {
            LOG.warn("Not executing search, it is referencing inaccessible streams: [" + Joiner.on((char)',').join(forbiddenStreams) + "]");
            this.throwStreamAccessForbiddenException();
        }
    }

    private void throwStreamAccessForbiddenException() {
        throw new ForbiddenException("The search is referencing at least one stream you are not permitted to see.");
    }

    @POST
    @ApiOperation(value="Execute the referenced search query asynchronously", notes="Starts a new search, irrespective whether or not another is already running")
    @Path(value="{id}/execute")
    @AuditEvent(type="views:search_job:create")
    public Response executeQuery(@ApiParam(name="id") @PathParam(value="id") String id, @ApiParam Map<String, Object> executionState) {
        Map<String, PluginMetadataSummary> missingRequirements;
        Search search = this.getSearch(id);
        Optional<Set> usedStreamIds = search.queries().stream().map(Query::usedStreamIds).reduce(Sets::union);
        this.checkUserIsPermittedToSeeStreams(usedStreamIds.orElse(Collections.emptySet()));
        boolean isAnyQueryWithoutStreams = search.queries().stream().anyMatch(query -> query.usedStreamIds().isEmpty());
        if (isAnyQueryWithoutStreams) {
            Set<String> allAvailableStreamIds = this.availableStreamIds();
            if (allAvailableStreamIds.isEmpty()) {
                this.throwStreamAccessForbiddenException();
            }
            ImmutableSet newQueries = (ImmutableSet)search.queries().stream().map(query -> {
                if (query.usedStreamIds().isEmpty()) {
                    return query.toBuilder().filter(this.addStreamIdsToFilter(allAvailableStreamIds, query.filter())).build();
                }
                return query;
            }).collect(ImmutableSet.toImmutableSet());
            search = search.toBuilder().queries((ImmutableSet<Query>)newQueries).build();
        }
        if (!(missingRequirements = this.missingRequirementsForEach(search)).isEmpty()) {
            ImmutableMap error = ImmutableMap.of((Object)"error", (Object)"Unable to execute this search, the following capabilities are missing:", (Object)"missing", missingRequirements);
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)error).build();
        }
        search = search.applyExecutionState(this.objectMapper, (Map)MoreObjects.firstNonNull(executionState, Collections.emptyMap()));
        String username = this.getCurrentUser() != null ? this.getCurrentUser().getName() : null;
        SearchJob searchJob = this.searchJobService.create(search, username);
        SearchJob runningSearchJob = this.queryEngine.execute(searchJob);
        return Response.created((URI)URI.create("views/search/status/" + runningSearchJob.getId())).entity((Object)runningSearchJob).build();
    }

    private Map<String, PluginMetadataSummary> missingRequirementsForEach(Search search) {
        return search.requires().entrySet().stream().filter(entry -> !this.providedCapabilities.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Filter addStreamIdsToFilter(Set<String> allAvailableStreamIds, Filter filter) {
        Filter orFilter = this.filteringForStreamIds(allAvailableStreamIds);
        if (filter == null) {
            return orFilter;
        }
        return AndFilter.and(orFilter, filter);
    }

    private Set<String> availableStreamIds() {
        return this.streamService.loadAll().stream().map(Persisted::getId).filter(streamId -> this.isPermitted("streams:read", (String)streamId)).collect(Collectors.toSet());
    }

    private Filter filteringForStreamIds(Set<String> streamIds) {
        Set<Filter> streamFilters = streamIds.stream().map(StreamFilter::ofId).collect(Collectors.toSet());
        return OrFilter.builder().filters(streamFilters).build();
    }

    @GET
    @ApiOperation(value="Retrieve the status of an executed query")
    @Path(value="status/{jobId}")
    public SearchJob jobStatus(@ApiParam(name="jobId") @PathParam(value="jobId") String jobId) {
        String username = this.getCurrentUser() != null ? this.getCurrentUser().getName() : null;
        SearchJob searchJob = this.searchJobService.load(jobId, username).orElseThrow(NotFoundException::new);
        try {
            Uninterruptibles.getUninterruptibly(searchJob.getResultFuture(), (long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException exception) {
            // empty catch block
        }
        return searchJob;
    }

    @POST
    @ApiOperation(value="Execute a new synchronous search", notes="Executes a new search and waits for its result")
    @Path(value="sync")
    @AuditEvent(type="views:search:execute")
    public SearchJob executeSyncJob(@ApiParam Search search, @ApiParam(name="timeout", defaultValue="60000") @QueryParam(value="timeout") @DefaultValue(value="60000") long timeout) {
        String username = this.getCurrentUser() != null ? this.getCurrentUser().getName() : null;
        SearchJob searchJob = this.queryEngine.execute(this.searchJobService.create(search, username));
        try {
            Uninterruptibles.getUninterruptibly(searchJob.getResultFuture(), (long)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            LOG.error("Error executing search job <{}>", (Object)searchJob.getId(), (Object)e);
            throw new InternalServerErrorException("Error executing search job: " + e.getMessage());
        }
        catch (TimeoutException e) {
            throw new InternalServerErrorException("Timeout while executing search job");
        }
        catch (Exception e) {
            LOG.error("Other error", (Throwable)e);
            throw e;
        }
        return searchJob;
    }

    @GET
    @ApiOperation(value="Metadata for the given Search object", notes="Used for already persisted search objects")
    @Path(value="metadata/{searchId}")
    public SearchMetadata metadata(@ApiParam(value="searchId") @PathParam(value="searchId") String searchId) {
        Search search = this.getSearch(searchId);
        return this.metadataForObject(search);
    }

    @POST
    @ApiOperation(value="Metadata for the posted Search object", notes="Intended for search objects that aren't yet persisted (e.g. for validation or interactive purposes)")
    @Path(value="metadata")
    @NoAuditEvent(value="Only returning metadata for given search, not changing any data")
    public SearchMetadata metadataForObject(@ApiParam @NotNull Search search) {
        if (search == null) {
            throw new IllegalArgumentException("Search must not be null.");
        }
        Map queryMetadatas = StreamEx.of(search.queries()).toMap(Query::id, query -> this.queryEngine.parse(search, (Query)query));
        return SearchMetadata.create(queryMetadatas, (ImmutableMap<String, Parameter>)Maps.uniqueIndex(search.parameters(), Parameter::name));
    }
}

