/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import org.elasticsearch.search.sort.SortOrder;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.searchtypes.GroupBy;

final class AutoValue_GroupBy
extends GroupBy {
    private final String type;
    private final String id;
    private final Filter filter;
    private final List<String> fields;
    @Min(value=1L)
    private final @Min(value=1L) long limit;
    private final GroupBy.Operation operation;
    private final SortOrder order;

    private AutoValue_GroupBy(String type, @Nullable String id, @Nullable Filter filter, List<String> fields, @Min(value=1L) @Min(value=1L) long limit, GroupBy.Operation operation, SortOrder order) {
        this.type = type;
        this.id = id;
        this.filter = filter;
        this.fields = fields;
        this.limit = limit;
        this.operation = operation;
        this.order = order;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    @JsonProperty
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public Filter filter() {
        return this.filter;
    }

    @Override
    @JsonProperty
    public List<String> fields() {
        return this.fields;
    }

    @Override
    @JsonProperty
    @Min(value=1L)
    public @Min(value=1L) long limit() {
        return this.limit;
    }

    @Override
    @JsonProperty
    public GroupBy.Operation operation() {
        return this.operation;
    }

    @Override
    @JsonProperty
    public SortOrder order() {
        return this.order;
    }

    public String toString() {
        return "GroupBy{type=" + this.type + ", id=" + this.id + ", filter=" + this.filter + ", fields=" + this.fields + ", limit=" + this.limit + ", operation=" + (Object)((Object)this.operation) + ", order=" + this.order + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GroupBy) {
            GroupBy that = (GroupBy)o;
            return this.type.equals(that.type()) && (this.id == null ? that.id() == null : this.id.equals(that.id())) && (this.filter == null ? that.filter() == null : this.filter.equals(that.filter())) && this.fields.equals(that.fields()) && this.limit == that.limit() && this.operation.equals((Object)that.operation()) && this.order.equals((Object)that.order());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.filter == null ? 0 : this.filter.hashCode();
        h$ *= 1000003;
        h$ ^= this.fields.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.limit >>> 32 ^ this.limit);
        h$ *= 1000003;
        h$ ^= this.operation.hashCode();
        h$ *= 1000003;
        return h$ ^= this.order.hashCode();
    }

    @Override
    public GroupBy.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends GroupBy.Builder {
        private String type;
        private String id;
        private Filter filter;
        private List<String> fields;
        private Long limit;
        private GroupBy.Operation operation;
        private SortOrder order;

        Builder() {
        }

        private Builder(GroupBy source) {
            this.type = source.type();
            this.id = source.id();
            this.filter = source.filter();
            this.fields = source.fields();
            this.limit = source.limit();
            this.operation = source.operation();
            this.order = source.order();
        }

        @Override
        public GroupBy.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public GroupBy.Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @Override
        public GroupBy.Builder filter(@Nullable Filter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public GroupBy.Builder fields(List<String> fields) {
            if (fields == null) {
                throw new NullPointerException("Null fields");
            }
            this.fields = fields;
            return this;
        }

        @Override
        public GroupBy.Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public GroupBy.Builder operation(GroupBy.Operation operation) {
            if (operation == null) {
                throw new NullPointerException("Null operation");
            }
            this.operation = operation;
            return this;
        }

        @Override
        public GroupBy.Builder order(SortOrder order) {
            if (order == null) {
                throw new NullPointerException("Null order");
            }
            this.order = order;
            return this;
        }

        @Override
        public GroupBy build() {
            String missing = "";
            if (this.type == null) {
                missing = missing + " type";
            }
            if (this.fields == null) {
                missing = missing + " fields";
            }
            if (this.limit == null) {
                missing = missing + " limit";
            }
            if (this.operation == null) {
                missing = missing + " operation";
            }
            if (this.order == null) {
                missing = missing + " order";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GroupBy(this.type, this.id, this.filter, this.fields, this.limit, this.operation, this.order);
        }
    }
}

