/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.searchtypes.AutoValue_DateHistogram;
import org.graylog.plugins.views.search.searchtypes.AutoValue_DateHistogram_Result;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;

@JsonTypeName(value="date_histogram")
@JsonDeserialize(builder=AutoValue_DateHistogram.Builder.class)
@AutoValue
public abstract class DateHistogram
implements SearchType {
    public static final String NAME = "date_histogram";

    @Override
    public abstract String type();

    @Override
    @Nullable
    @JsonProperty
    public abstract String id();

    @Override
    @Nullable
    public abstract Filter filter();

    @JsonProperty
    public abstract Searches.DateHistogramInterval interval();

    @Override
    public SearchType applyExecutionContext(ObjectMapper objectMapper, JsonNode state) {
        if (state.hasNonNull("interval")) {
            String interval = state.path("interval").asText();
            Builder builder = this.toBuilder().interval(Searches.DateHistogramInterval.valueOf(interval.toUpperCase(Locale.ENGLISH)));
            return builder.build();
        }
        return this;
    }

    abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_DateHistogram.Builder();
    }

    @AutoValue
    public static abstract class Result
    implements SearchType.Result {
        @Override
        @JsonProperty
        public abstract String id();

        @Override
        @JsonProperty
        public String type() {
            return DateHistogram.NAME;
        }

        @JsonProperty
        public abstract Map<Long, Long> results();

        @JsonProperty
        public abstract AbsoluteRange timerange();

        public static Builder builder() {
            return new AutoValue_DateHistogram_Result.Builder();
        }

        public static Builder result(String searchTypeId) {
            return Result.builder().id(searchTypeId);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder id(String var1);

            public abstract Builder results(Map<Long, Long> var1);

            public abstract Builder timerange(AbsoluteRange var1);

            public abstract Result build();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder type(String var1);

        @JsonProperty
        public abstract Builder id(@Nullable String var1);

        @JsonProperty
        public abstract Builder filter(@Nullable Filter var1);

        @JsonProperty
        public abstract Builder interval(Searches.DateHistogramInterval var1);

        public abstract DateHistogram build();
    }
}

