/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import org.elasticsearch.search.sort.SortOrder;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.searchtypes.AutoValue_GroupBy;
import org.graylog.plugins.views.search.searchtypes.AutoValue_GroupBy_Group;
import org.graylog.plugins.views.search.searchtypes.AutoValue_GroupBy_GroupField;
import org.graylog.plugins.views.search.searchtypes.AutoValue_GroupBy_Result;

@JsonTypeName(value="group_by")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GroupBy
implements SearchType {
    public static final String NAME = "group_by";
    private static final long DEFAULT_LIMIT = 5L;
    private static final SortOrder DEFAULT_SORT_ORDER = SortOrder.DESC;
    private static final Operation DEFAULT_OPERATION = Operation.COUNT;

    @Override
    public abstract String type();

    @Override
    @Nullable
    @JsonProperty
    public abstract String id();

    @Override
    @Nullable
    public abstract Filter filter();

    @JsonProperty
    public abstract List<String> fields();

    @Min(value=1L)
    @JsonProperty
    public abstract @Min(value=1L) long limit();

    @JsonProperty
    public abstract Operation operation();

    @JsonProperty
    public abstract SortOrder order();

    public static Builder builder() {
        return new AutoValue_GroupBy.Builder().type(NAME).limit(5L).order(DEFAULT_SORT_ORDER).operation(DEFAULT_OPERATION);
    }

    public abstract Builder toBuilder();

    @Override
    public SearchType applyExecutionContext(ObjectMapper objectMapper, JsonNode state) {
        return this;
    }

    @AutoValue
    public static abstract class GroupField {
        @JsonProperty
        public abstract String field();

        @JsonProperty
        public abstract String value();

        public static Builder builder() {
            return new AutoValue_GroupBy_GroupField.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty
            public abstract Builder field(String var1);

            @JsonProperty
            public abstract Builder value(String var1);

            public abstract GroupField build();
        }
    }

    @AutoValue
    public static abstract class Group {
        @JsonProperty
        public abstract long count();

        @JsonProperty
        public abstract List<GroupField> fields();

        public static Builder builder() {
            return new AutoValue_GroupBy_Group.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty
            public abstract Builder count(long var1);

            @JsonProperty
            public abstract Builder fields(List<GroupField> var1);

            public abstract Group build();
        }
    }

    @AutoValue
    public static abstract class Result
    implements SearchType.Result {
        @Override
        @JsonProperty
        public abstract String id();

        @Override
        @JsonProperty
        public String type() {
            return GroupBy.NAME;
        }

        @JsonProperty
        public abstract List<Group> groups();

        public static Builder builder() {
            return new AutoValue_GroupBy_Result.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder id(String var1);

            public abstract Builder groups(List<Group> var1);

            public abstract Result build();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder createDefault() {
            return GroupBy.builder();
        }

        @JsonProperty
        public abstract Builder type(String var1);

        @JsonProperty
        public abstract Builder id(@Nullable String var1);

        @JsonProperty
        public abstract Builder filter(@Nullable Filter var1);

        @JsonProperty
        public abstract Builder fields(List<String> var1);

        @JsonProperty
        public abstract Builder limit(long var1);

        @JsonProperty
        public abstract Builder operation(Operation var1);

        @JsonProperty
        public abstract Builder order(SortOrder var1);

        public abstract GroupBy build();
    }

    public static enum Operation {
        COUNT;

    }
}

