/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.List;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.searchtypes.AutoValue_MessageList;
import org.graylog.plugins.views.search.searchtypes.AutoValue_MessageList_Result;
import org.graylog.plugins.views.search.searchtypes.Sort;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;

@JsonTypeName(value="messages")
@JsonDeserialize(builder=AutoValue_MessageList.Builder.class)
@AutoValue
public abstract class MessageList
implements SearchType {
    public static final String NAME = "messages";

    @Override
    public abstract String type();

    @Override
    @Nullable
    @JsonProperty
    public abstract String id();

    @Override
    @Nullable
    public abstract Filter filter();

    @JsonProperty
    public abstract int limit();

    @JsonProperty
    public abstract int offset();

    @Nullable
    public abstract List<Sort> sort();

    public static Builder builder() {
        return new AutoValue_MessageList.Builder().type(NAME).limit(150).offset(0);
    }

    public abstract Builder toBuilder();

    @Override
    public SearchType applyExecutionContext(ObjectMapper objectMapper, JsonNode state) {
        boolean hasLimit = state.hasNonNull("limit");
        boolean hasOffset = state.hasNonNull("offset");
        if (hasLimit || hasOffset) {
            Builder builder = this.toBuilder();
            if (hasLimit) {
                builder.limit(state.path("limit").asInt());
            }
            if (hasOffset) {
                builder.offset(state.path("offset").asInt());
            }
            return builder.build();
        }
        return this;
    }

    @AutoValue
    public static abstract class Result
    implements SearchType.Result {
        @Override
        @JsonProperty
        public abstract String id();

        @Override
        @JsonProperty
        public String type() {
            return MessageList.NAME;
        }

        @JsonProperty
        public abstract List<ResultMessageSummary> messages();

        @JsonProperty
        public abstract long totalResults();

        public static Builder builder() {
            return new AutoValue_MessageList_Result.Builder();
        }

        public static Builder result(String searchTypeId) {
            return Result.builder().id(searchTypeId);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder id(String var1);

            public abstract Builder messages(List<ResultMessageSummary> var1);

            public abstract Builder totalResults(long var1);

            public abstract Result build();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder type(String var1);

        @JsonProperty
        public abstract Builder id(@Nullable String var1);

        @JsonProperty
        public abstract Builder filter(@Nullable Filter var1);

        @JsonProperty
        public abstract Builder limit(int var1);

        @JsonProperty
        public abstract Builder offset(int var1);

        @JsonProperty
        public abstract Builder sort(@Nullable List<Sort> var1);

        public abstract MessageList build();
    }
}

